/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public abstract class ToStringCompiler
extends ToItemCompiler {
    @Override
    public final void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileItemFromString(compiler, expression);
    }

    protected final void compileItemFromString(CompilerService compiler, Expression expression) throws CannotCompileException {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        Generator ga = compiler.getCurrentGenerator();
        if (Cardinality.allowsZero(expression.getCardinality())) {
            LabelInfo returnNull = methodInfo.newLabel("returnNull");
            LabelInfo exit = methodInfo.newLabel("exit");
            this.compileToPrimitive(compiler, expression, CharSequence.class, new OnEmpty.UnwindAndJump(returnNull));
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
            ga.goTo(exit);
            methodInfo.placeLabel(returnNull);
            ga.pushNull();
            methodInfo.placeLabel(exit);
        } else {
            this.compileToPrimitive(compiler, expression, CharSequence.class, OnEmpty.RETURN_NULL);
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
        }
    }
}

