/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class ValueComparisonCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        ValueComparison expr = (ValueComparison)expression;
        ValueComparisonCompiler.compile(compiler, expression, expr.getLhsExpression(), expr.getRhsExpression(), expr.getOperator(), expr.getAtomicComparer(), true);
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        ValueComparison expr = (ValueComparison)expression;
        ValueComparisonCompiler.compile(compiler, expression, expr.getLhsExpression(), expr.getRhsExpression(), expr.getOperator(), expr.getAtomicComparer(), false);
    }

    private static void compile(CompilerService compiler, Expression expression, Expression lhs, Expression rhs, int op, AtomicComparer comparer, boolean toItem) throws CannotCompileException {
        LabelInfo returnEmpty;
        LabelInfo returnTrue;
        LabelInfo returnFalse;
        LabelInfo done;
        GeneratedMethodInfo methodInfo;
        Generator ga;
        block54: {
            LabelInfo L2;
            LabelInfo L1;
            LabelInfo endTryCatch;
            int op1Var;
            int op0Var;
            block56: {
                block57: {
                    block55: {
                        ItemType type1;
                        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
                        ga = compiler.getCurrentGenerator();
                        methodInfo = compiler.getCurrentMethod();
                        ValueComparisonCompiler.visitAnnotation(compiler, expression instanceof ValueComparison ? "ValueComparison-compare" : "SingletonComparison-compare");
                        BooleanValue resultWhenEmpty = null;
                        boolean needsRuntime = false;
                        if (expression instanceof ValueComparison) {
                            resultWhenEmpty = ((ValueComparison)expression).getResultWhenEmpty();
                            needsRuntime = ((ValueComparison)expression).needsRuntimeComparabilityCheck();
                        }
                        boolean maybeEmpty0 = Cardinality.allowsZero(lhs.getCardinality());
                        boolean maybeEmpty1 = Cardinality.allowsZero(rhs.getCardinality());
                        ItemType type0 = lhs.getItemType();
                        if (type0 == BuiltInAtomicType.UNTYPED_ATOMIC) {
                            type0 = BuiltInAtomicType.STRING;
                        }
                        if ((type1 = rhs.getItemType()) == BuiltInAtomicType.UNTYPED_ATOMIC) {
                            type1 = BuiltInAtomicType.STRING;
                        }
                        done = methodInfo.newLabel("doneVC");
                        returnFalse = methodInfo.newLabel("returnFalseValueComp");
                        returnTrue = methodInfo.newLabel("returnTrueValueComp");
                        returnEmpty = null;
                        Stack<Class> stack = new Stack<Class>();
                        boolean finished = false;
                        if (type0 == type1) {
                            LabelInfo emptyOperandReturn = resultWhenEmpty == null && toItem ? (returnEmpty = methodInfo.newLabel("returnEmpty")) : (resultWhenEmpty != null && resultWhenEmpty.getBooleanValue() ? returnTrue : returnFalse);
                            OnEmpty.UnwindAndJump onEmptyBoolean = new OnEmpty.UnwindAndJump(stack, emptyOperandReturn);
                            OnEmpty.UnwindAndJump onEmptyItem = new OnEmpty.UnwindAndJump(stack, emptyOperandReturn);
                            if (type0 == BuiltInAtomicType.BOOLEAN && !maybeEmpty0 && !maybeEmpty1) {
                                compiler.compileToBoolean(lhs);
                                compiler.compileToBoolean(rhs);
                                ga.ifCmp(Type.BOOLEAN_TYPE, ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                ga.goTo(returnFalse);
                                finished = true;
                            } else if (type0 == BuiltInAtomicType.INTEGER && compiler.isInRangeForInt(lhs) && compiler.isInRangeForInt(rhs)) {
                                compiler.compileToPrimitive(lhs, Integer.TYPE, onEmptyBoolean);
                                stack.push(Integer.TYPE);
                                compiler.compileToPrimitive(rhs, Integer.TYPE, onEmptyBoolean);
                                ga.ifCmp(Type.INT_TYPE, ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                ga.goTo(returnFalse);
                                finished = true;
                            } else if (type0 == BuiltInAtomicType.INTEGER && compiler.isInRangeForLong(lhs) && compiler.isInRangeForLong(rhs)) {
                                compiler.compileToPrimitive(lhs, Long.TYPE, onEmptyBoolean);
                                stack.push(Long.TYPE);
                                compiler.compileToPrimitive(rhs, Long.TYPE, onEmptyBoolean);
                                ga.ifCmp(Type.LONG_TYPE, ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                ga.goTo(returnFalse);
                                finished = true;
                            } else if (type0 == BuiltInAtomicType.DOUBLE) {
                                compiler.compileToPrimitive(lhs, Double.TYPE, onEmptyBoolean);
                                stack.push(Double.TYPE);
                                compiler.compileToPrimitive(rhs, Double.TYPE, onEmptyBoolean);
                                ga.ifCmp(Type.DOUBLE_TYPE, ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                ga.goTo(returnFalse);
                                finished = true;
                            } else if (type0 == BuiltInAtomicType.FLOAT) {
                                compiler.compileToPrimitive(lhs, Float.TYPE, onEmptyBoolean);
                                stack.push(Float.TYPE);
                                compiler.compileToPrimitive(rhs, Float.TYPE, onEmptyBoolean);
                                ga.ifCmp(Type.FLOAT_TYPE, ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                ga.goTo(returnFalse);
                                finished = true;
                            } else if (type0 == BuiltInAtomicType.STRING && comparer instanceof CodepointCollatingComparer) {
                                switch (op) {
                                    case 50: 
                                    case 51: {
                                        compiler.compileToPrimitive(lhs, String.class, toItem ? onEmptyItem : onEmptyBoolean);
                                        stack.push(String.class);
                                        compiler.compileToPrimitive(rhs, String.class, toItem ? onEmptyItem : onEmptyBoolean);
                                        ga.invokeInstanceMethod(String.class, "equals", Object.class);
                                        if (op == 51) {
                                            ga.not();
                                        }
                                        ga.goTo(done);
                                        break;
                                    }
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: {
                                        compiler.compileToPrimitive(lhs, CharSequence.class, toItem ? onEmptyItem : onEmptyBoolean);
                                        stack.push(CharSequence.class);
                                        compiler.compileToPrimitive(rhs, CharSequence.class, toItem ? onEmptyItem : onEmptyBoolean);
                                        ga.invokeStaticMethod(CodepointCollator.class, "compareCS", CharSequence.class, CharSequence.class);
                                        ga.ifZCmp(ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                        ga.goTo(returnFalse);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("unknown operator");
                                    }
                                }
                                finished = true;
                            }
                        }
                        if (finished) break block54;
                        compiler.compileToItem(lhs);
                        ga.checkClass(AtomicValue.class);
                        op0Var = methodInfo.allocateLocal(AtomicValue.class);
                        ga.storeLocal(op0Var);
                        if (maybeEmpty0) {
                            ga.loadLocal(op0Var);
                            if (toItem) {
                                if (resultWhenEmpty == null) {
                                    returnEmpty = methodInfo.newLabel("returnEmpty");
                                    ga.ifNull(returnEmpty.label());
                                } else {
                                    ga.ifNull(resultWhenEmpty.getBooleanValue() ? returnTrue.label() : returnFalse.label());
                                }
                            } else {
                                ga.ifNull(resultWhenEmpty == BooleanValue.TRUE ? returnTrue.label() : returnFalse.label());
                            }
                        }
                        compiler.compileToItem(rhs);
                        ga.checkClass(AtomicValue.class);
                        op1Var = methodInfo.allocateLocal(AtomicValue.class);
                        ga.storeLocal(op1Var);
                        if (maybeEmpty1) {
                            ga.loadLocal(op1Var);
                            if (toItem) {
                                if (resultWhenEmpty == null) {
                                    if (returnEmpty == null) {
                                        returnEmpty = methodInfo.newLabel("returnEmpty");
                                    }
                                    ga.ifNull(returnEmpty.label());
                                } else {
                                    ga.ifNull(resultWhenEmpty.getBooleanValue() ? returnTrue.label() : returnFalse.label());
                                }
                            } else {
                                ga.ifNull(resultWhenEmpty == BooleanValue.TRUE ? returnTrue.label() : returnFalse.label());
                            }
                        }
                        if (needsRuntime) {
                            ValueComparisonCompiler.visitLineNumber(compiler, ga, expression);
                            LabelInfo isCompLab = methodInfo.newLabel("isCompLab");
                            ga.loadLocal(op0Var);
                            ga.checkClass(AtomicValue.class);
                            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                            ga.loadLocal(op1Var);
                            ga.checkClass(AtomicValue.class);
                            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                            ga.push(Token.isOrderedOperator(op));
                            ga.invokeStaticMethod(net.sf.saxon.type.Type.class, "isGuaranteedComparable", BuiltInAtomicType.class, BuiltInAtomicType.class, Boolean.TYPE);
                            ga.ifZCmp(154, isCompLab.label());
                            ga.loadLocal(op0Var);
                            ga.checkClass(AtomicValue.class);
                            ga.loadLocal(op1Var);
                            ga.checkClass(AtomicValue.class);
                            ga.push(expression.getLocation().getSystemId());
                            ga.push(expression.getLocation().getLineNumber());
                            ga.invokeStaticMethod(Callback.class, "makeNonComparableException", AtomicValue.class, AtomicValue.class, String.class, Integer.TYPE);
                            ga.throwException();
                            methodInfo.placeLabel(isCompLab);
                        }
                        int r0d = th.relationship(lhs.getItemType(), BuiltInAtomicType.DOUBLE);
                        int r0f = th.relationship(lhs.getItemType(), BuiltInAtomicType.FLOAT);
                        int r1d = th.relationship(rhs.getItemType(), BuiltInAtomicType.DOUBLE);
                        int r1f = th.relationship(rhs.getItemType(), BuiltInAtomicType.FLOAT);
                        if (r0d != 4 || r0f != 4) {
                            ga.loadLocal(op0Var);
                            ga.checkClass(AtomicValue.class);
                            ga.invokeInstanceMethod(AtomicValue.class, "isNaN", new Class[0]);
                            ga.ifZCmp(154, op == 51 ? returnTrue.label() : returnFalse.label());
                        }
                        if (r1d != 4 || r1f != 4) {
                            ga.loadLocal(op1Var);
                            ga.checkClass(AtomicValue.class);
                            ga.invokeInstanceMethod(AtomicValue.class, "isNaN", new Class[0]);
                            ga.ifZCmp(154, op == 51 ? returnTrue.label() : returnFalse.label());
                        }
                        LabelInfo L0 = methodInfo.newLabel("L0");
                        endTryCatch = methodInfo.newLabel("EndTryCatch_ValueCom");
                        L1 = methodInfo.newLabel("L1");
                        L2 = methodInfo.newLabel("L2");
                        ga.visitTryCatchBlock(L0, L1, L2, "java/lang/ClassCastException");
                        methodInfo.placeLabel(L0);
                        ValueComparisonCompiler.visitLineNumber(compiler, ga, expression);
                        if (!(comparer instanceof ComparableAtomicValueComparer)) break block55;
                        switch (op) {
                            case 50: 
                            case 51: {
                                ga.loadLocal(op0Var);
                                ga.loadLocal(op1Var);
                                ga.invokeInstanceMethod(AtomicValue.class, "equals", Object.class);
                                if (op == 51) {
                                    ga.not();
                                }
                                ga.goTo(done);
                                break block56;
                            }
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: {
                                ga.loadLocal(op0Var);
                                ga.checkClass(Comparable.class);
                                ga.loadLocal(op1Var);
                                ga.invokeInstanceMethod(Comparable.class, "compareTo", Object.class);
                                ga.ifZCmp(ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                                ga.goTo(returnFalse);
                                break block56;
                            }
                            default: {
                                throw new IllegalStateException("unknown operator");
                            }
                        }
                    }
                    if (!(comparer instanceof CodepointCollatingComparer)) break block57;
                    switch (op) {
                        case 50: 
                        case 51: {
                            ga.loadLocal(op0Var);
                            ga.checkClass(StringValue.class);
                            ga.loadLocal(op1Var);
                            ga.checkClass(StringValue.class);
                            ga.invokeInstanceMethod(StringValue.class, "codepointEquals", StringValue.class);
                            if (op == 51) {
                                ga.not();
                            }
                            ga.goTo(done);
                            break block56;
                        }
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            ga.loadLocal(op0Var);
                            ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
                            ga.loadLocal(op1Var);
                            ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
                            ga.invokeStaticMethod(CodepointCollator.class, "compareCS", CharSequence.class, CharSequence.class);
                            ga.ifZCmp(ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                            ga.goTo(returnFalse);
                            break block56;
                        }
                        default: {
                            throw new IllegalStateException("unknown operator");
                        }
                    }
                }
                ValueComparisonCompiler.allocateStatic(compiler, comparer);
                compiler.generateGetContext();
                ga.invokeInstanceMethod(AtomicComparer.class, "provideContext", XPathContext.class);
                int comparerVar = methodInfo.allocateLocal(AtomicComparer.class);
                ga.storeLocal(comparerVar);
                switch (op) {
                    case 50: 
                    case 51: {
                        ga.loadLocal(comparerVar);
                        ga.loadLocal(op0Var);
                        ga.loadLocal(op1Var);
                        ga.invokeInstanceMethod(AtomicComparer.class, "comparesEqual", AtomicValue.class, AtomicValue.class);
                        if (op == 51) {
                            ga.not();
                        }
                        ga.goTo(done);
                        break;
                    }
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        ga.loadLocal(comparerVar);
                        ga.loadLocal(op0Var);
                        ga.loadLocal(op1Var);
                        ga.invokeInstanceMethod(AtomicComparer.class, "compareAtomicValues", AtomicValue.class, AtomicValue.class);
                        ga.ifZCmp(ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                        ga.goTo(returnFalse);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown operator");
                    }
                }
                methodInfo.releaseLocal(comparerVar);
            }
            methodInfo.releaseLocal(op0Var);
            methodInfo.releaseLocal(op1Var);
            methodInfo.placeLabel(L1);
            ga.goTo(endTryCatch.label());
            methodInfo.placeLabel(L2);
            ValueComparisonCompiler.visitAnnotation(compiler, "Catch");
            ga.loadLocal(op0Var);
            ga.checkClass(AtomicValue.class);
            ga.loadLocal(op1Var);
            ga.checkClass(AtomicValue.class);
            ga.push(expression.getLocation().getSystemId());
            ga.push(expression.getLocation().getLineNumber());
            ga.invokeStaticMethod(Callback.class, "makeNonComparableException", AtomicValue.class, AtomicValue.class, String.class, Integer.TYPE);
            ga.throwException();
            methodInfo.placeLabel(endTryCatch);
        }
        if (returnTrue.isUsed()) {
            methodInfo.placeLabel(returnTrue);
            ga.push(true);
            if (returnFalse.isUsed()) {
                ga.goTo(done);
            }
        }
        if (returnFalse.isUsed()) {
            methodInfo.placeLabel(returnFalse);
            ga.showMessage(compiler, "ValueComp-returnFalse returnEmpty:" + returnEmpty);
            ga.push(false);
        }
        methodInfo.placeLabel(done);
        if (toItem) {
            ga.showMessage(compiler, "ValueComp-toItem");
            ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
        }
        if (returnEmpty != null) {
            LabelInfo reallyDone = methodInfo.newLabel("reallyDone");
            ga.goTo(reallyDone);
            methodInfo.placeLabel(returnEmpty);
            ga.showMessage(compiler, "ValueComp-returnEmpty");
            ga.pushNull();
            methodInfo.placeLabel(reallyDone);
        }
    }

    public static int translateOperator(int op) {
        switch (op) {
            case 50: {
                return 153;
            }
            case 51: {
                return 154;
            }
            case 52: {
                return 157;
            }
            case 53: {
                return 155;
            }
            case 54: {
                return 156;
            }
            case 55: {
                return 158;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + op);
    }
}

