/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Int64Value;

public class IXSLScheduleAction
extends StyleElement {
    private Expression wait;
    private Expression document;
    private Expression httpRequest;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int c = 0;
        int d = 0;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("wait")) {
                this.wait = this.makeExpression(atts.getValue(a), a);
                ++c;
                continue;
            }
            if (f.equals("document")) {
                this.document = this.makeAttributeValueTemplate(atts.getValue(a), a);
                ++c;
                ++d;
                continue;
            }
            if (f.equals("http-request")) {
                this.httpRequest = this.makeExpression(atts.getValue(a), a);
                ++c;
                ++d;
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (c == 0) {
            this.compileError("At least one attribute should be set on ixsl:schedule-action", "XTSE0010");
        }
        if (d == 2) {
            this.compileError("Combination of attributes set on ixsl:schedule-action is not permitted", "XTSE0010");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child2;
        AxisIterator kids;
        NodeInfo child1;
        this.wait = this.typeCheck("wait", this.wait);
        this.document = this.typeCheck("document", this.document);
        this.httpRequest = this.typeCheck("http-request", this.httpRequest);
        if (this.wait == null) {
            this.wait = Literal.makeLiteral(Int64Value.ZERO);
        }
        if (this.document == null) {
            this.document = Literal.makeEmptySequence();
        }
        if ((child1 = (kids = this.iterateAxis((byte)3)).next()) != null && !(child1 instanceof XSLCallTemplate)) {
            this.compileError("Only xsl:call-template is allowed within ixsl:schedule-action", "XTSE0010");
        }
        if ((child2 = kids.next()) != null) {
            this.compileError("Only one child permitted within ixsl:schedule-action", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression action = this.compileSequenceConstructor(exec, decl, true);
        if (action == null) {
            action = Literal.makeEmptySequence();
        }
        Expression e = this.httpRequest == null ? IXSLFunctionSet.getInstance().makeFunction("schedule-action", 3).makeFunctionCall(this.wait, this.document, action) : IXSLFunctionSet.getInstance().makeFunction("schedule-action", 4).makeFunctionCall(this.wait, this.document, action, this.httpRequest);
        e.setRetainedStaticContext(this.makeRetainedStaticContext());
        return e;
    }
}

