/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.AttributeSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanAttributeQuery
extends SimpleSpanQuery {
    boolean negation;

    public SpanAttributeQuery(SpanTermQuery firstClause, boolean collectPayloads) {
        super(firstClause, collectPayloads);
    }

    public SpanAttributeQuery(SpanTermQuery firstClause, boolean negation, boolean collectPayloads) {
        super(firstClause, collectPayloads);
        this.negation = negation;
    }

    @Override
    public SimpleSpanQuery clone() {
        SpanAttributeQuery sq = new SpanAttributeQuery((SpanTermQuery)this.firstClause.clone(), this.negation, this.collectPayloads);
        sq.setBoost(this.getBoost());
        return sq;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new AttributeSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("spanAttribute(");
        if (this.negation) {
            sb.append("!");
        }
        sb.append(this.firstClause.toString(field));
        sb.append(")");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    public boolean isNegation() {
        return this.negation;
    }

    public void setNegation(boolean negation) {
        this.negation = negation;
    }
}

