/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.lucene50.Lucene50CompoundReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public final class Lucene50CompoundFormat
extends CompoundFormat {
    static final String DATA_EXTENSION = "cfs";
    static final String ENTRIES_EXTENSION = "cfe";
    static final String DATA_CODEC = "Lucene50CompoundData";
    static final String ENTRY_CODEC = "Lucene50CompoundEntries";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    @Override
    public Directory getCompoundReader(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        return new Lucene50CompoundReader(dir, si, context);
    }

    @Override
    public void write(Directory dir, SegmentInfo si, Collection<String> files, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName(si.name, "", DATA_EXTENSION);
        String entriesFile = IndexFileNames.segmentFileName(si.name, "", ENTRIES_EXTENSION);
        try (IndexOutput data = dir.createOutput(dataFile, context);
             IndexOutput entries = dir.createOutput(entriesFile, context);){
            CodecUtil.writeIndexHeader(data, DATA_CODEC, 0, si.getId(), "");
            CodecUtil.writeIndexHeader(entries, ENTRY_CODEC, 0, si.getId(), "");
            entries.writeVInt(files.size());
            for (String file : files) {
                long startOffset = data.getFilePointer();
                try (IndexInput in = dir.openInput(file, IOContext.READONCE);){
                    data.copyBytes(in, in.length());
                }
                long endOffset = data.getFilePointer();
                long length = endOffset - startOffset;
                entries.writeString(IndexFileNames.stripSegmentName(file));
                entries.writeLong(startOffset);
                entries.writeLong(length);
            }
            CodecUtil.writeFooter(data);
            CodecUtil.writeFooter(entries);
        }
    }

    @Override
    public String[] files(SegmentInfo si) {
        return new String[]{IndexFileNames.segmentFileName(si.name, "", DATA_EXTENSION), IndexFileNames.segmentFileName(si.name, "", ENTRIES_EXTENSION)};
    }
}

