/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public class ValueConstraint {
    private Variety variety;
    private String lexicalForm;
    private AtomicSequence typedValue;
    private Comparable comparisonKey;

    public ValueConstraint(Variety variety, String lexicalForm) {
        this.variety = variety;
        this.lexicalForm = lexicalForm;
        this.typedValue = new UntypedAtomicValue(lexicalForm);
    }

    public Variety getVariety() {
        return this.variety;
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    void setLexicalForm(String value) {
        this.lexicalForm = value;
    }

    public AtomicSequence getValue() {
        return this.typedValue;
    }

    void setValue(AtomicSequence value) {
        this.typedValue = value;
        this.comparisonKey = value.getSchemaComparable();
    }

    public Comparable getComparisonKey() {
        return this.comparisonKey;
    }

    public Sequence<?> asFunction() {
        Callable constraintFunction = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue("Value Constraint");
                }
                case "variety": {
                    return new StringValue(this.variety == Variety.FIXED ? "fixed" : "default");
                }
                case "value": {
                    return this.getValue() == null ? new StringValue(this.getLexicalForm()) : this.getValue();
                }
                case "lexical form": {
                    return new StringValue(this.getLexicalForm());
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, constraintFunction, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }

    boolean makeTypedValue(SchemaCompiler compiler, SimpleType stype, NamespaceResolver resolver, Location loc) throws SchemaException {
        this.lexicalForm = Whitespace.applyWhitespaceNormalization(stype.getWhitespaceAction(), this.lexicalForm).toString();
        ConversionRules rules = compiler.getConfiguration().getConversionRules();
        ValidationFailure err = stype.validateContent(this.lexicalForm, resolver, rules);
        if (err != null) {
            String val = Err.wrap(this.lexicalForm, 4);
            compiler.error((this.variety == Variety.FIXED ? "Fixed" : "Default") + " value " + Err.wrap(val) + " does not not conform to the declared type: " + err.getMessage(), loc);
            return false;
        }
        try {
            if (stype.isNamespaceSensitive()) {
                this.setValue(stype.getTypedValue(this.lexicalForm, resolver, rules));
            } else if (stype.isAtomicType()) {
                this.setValue(Converter.convert(new StringValue(this.lexicalForm), (AtomicType)stype, rules));
            } else if (stype instanceof AnySimpleType) {
                this.setValue(new UntypedAtomicValue(this.lexicalForm));
            } else if (this.getValue().getLength() == 1) {
                this.setValue(stype.getTypedValue(this.lexicalForm, null, rules));
            }
            return true;
        }
        catch (XPathException e) {
            compiler.error(e.getMessage(), loc);
            return false;
        }
    }

    public boolean testFixedValue(Configuration config, CharSequence value, SimpleType type, NamespaceResolver resolver) throws ValidationException {
        if (this.variety != Variety.FIXED) {
            return true;
        }
        AtomicSequence actual = type.getTypedValue(value, resolver, config.getConversionRules());
        return actual.getSchemaComparable().equals(this.getComparisonKey());
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement(this.variety == Variety.FIXED ? "fixed" : "default");
        serializer.emitAttribute("lexicalForm", this.getLexicalForm());
        serializer.emitTypedValue(this.getValue());
        serializer.endElement();
    }

    public static enum Variety {
        DEFAULT,
        FIXED;

    }
}

