/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class SaxonParam
extends AnnotationParent {
    @Override
    public void prepareAttributes() throws SchemaException {
        String select;
        String as;
        Configuration config = this.getConfiguration();
        NodeImpl parent = this.getParent();
        if (parent == null || parent.getFingerprint() != 581) {
            this.error("The saxon:param element is allowed only as a child of xs:appinfo");
        }
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"as", "name", "select"};
        this.allowAttributes(atts, allowed);
        this.requireAttribute(atts, "name");
        String name = atts.getValue("", "name");
        StructuredQName qName = this.makeQName(name);
        if (qName.hasURI("") && qName.getLocalPart().equals("value")) {
            this.error("The variable name $value is reserved for system use");
        }
        if ((as = atts.getValue("", "as")) == null) {
            as = "item()*";
        }
        if ((select = atts.getValue("", "select")) == null) {
            select = "()";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this, this.getConfiguration());
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        env.setXPathLanguageLevel(31);
        SequenceType requiredType = this.makeSequenceType(as, env);
        GroundedValue<Object> defaultValue = EmptySequence.getInstance();
        try {
            Expression expr = ExpressionTool.make(select, env, 0, 0, null);
            RoleDiagnostic role = new RoleDiagnostic(8, name, 0);
            ExpressionVisitor visitor = ExpressionVisitor.make(env);
            ItemType contextItemType = Type.ITEM_TYPE;
            expr = expr.typeCheck(visitor, config.makeContextItemStaticInfo(contextItemType, true));
            expr = config.getTypeChecker(false).staticTypeCheck(expr, requiredType, role, visitor);
            SlotManager stackFrameMap = config.makeSlotManager();
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
            Controller controller = new Controller(config);
            XPathContextMajor dynamicContext = controller.newXPathContext();
            dynamicContext = dynamicContext.newCleanContext();
            dynamicContext.openStackFrame(stackFrameMap);
            defaultValue = expr.iterate(dynamicContext).materialize();
        }
        catch (XPathException e) {
            this.error(e.getMessage());
        }
        PackageData pd = new PackageData(this.getConfiguration());
        pd.setHostLanguage(11);
        pd.setSchemaAware(true);
        GlobalParam param = new GlobalParam();
        param.setPackageData(pd);
        param.setVariableQName(qName);
        param.setRequiredType(requiredType);
        param.setSelectExpression(Literal.makeLiteral(defaultValue));
        this.getXSDSchema().addGlobalParam(param);
    }

    public SequenceType makeSequenceType(String sequenceType, StaticContext env) throws SchemaException {
        try {
            XPathParser parser = new XPathParser();
            parser.setLanguage(0, 31);
            return parser.parseSequenceType(sequenceType, env);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            return SequenceType.ANY_SEQUENCE;
        }
    }

    public final StructuredQName makeQName(String lexicalQName) throws SchemaException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, true, this);
        }
        catch (XPathException e) {
            e.setIsStaticError(true);
            String code = e.getErrorCodeLocalPart();
            if ("FONS0004".equals(code)) {
                e.setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(code)) {
                e.setErrorCode("XTSE0020");
            } else if (code == null) {
                e.setErrorCode("XTSE0020");
            }
            throw new SchemaException(e);
        }
        return qName;
    }
}

