/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.validate.StartTagBufferEE;
import com.saxonica.ee.validate.ValidatingFilter;
import com.saxonica.ee.validate.ValidationStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorListener;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Whitespace;

public class XSIAttributeHandler
extends ValidatingFilter {
    private HashSet<String> namespacesEncountered;
    private HashMap<String, URI> schemaDocumentsRead;
    private boolean useXsiSchemaLocation = true;
    private List<ValidationFailure> xsiValidationErrors = new ArrayList<ValidationFailure>(4);

    public XSIAttributeHandler(ValidationStack out) {
        super(out);
        this.namespacesEncountered = new HashSet(10);
        this.schemaDocumentsRead = new HashMap(10);
        this.useXsiSchemaLocation = this.getPipelineConfiguration().getParseOptions().isUseXsiSchemaLocation();
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.useXsiSchemaLocation = pipe.getParseOptions().isUseXsiSchemaLocation();
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        boolean nilled = false;
        this.xsiValidationErrors.clear();
        StartTagBufferEE startTagBuffer = this.getStartTagBuffer();
        SchemaType xsiType = null;
        if (startTagBuffer.hasAttributeInNamespace("http://www.w3.org/2001/XMLSchema-instance")) {
            String value;
            if (this.useXsiSchemaLocation) {
                value = startTagBuffer.getAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
                if (value != null) {
                    this.processXsiNoNamespaceSchemaLocation(location, value);
                }
                if ((value = startTagBuffer.getAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")) != null) {
                    this.processXsiSchemaLocation(value, location);
                }
            }
            if ((value = startTagBuffer.getAttribute("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                xsiType = this.processXsiType(value);
            }
            if ((value = startTagBuffer.getAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null) {
                nilled = this.processXsiNil(value);
            }
        }
        if (this.nextReceiver instanceof ValidationStack) {
            ((ValidationStack)this.nextReceiver).setValidationContext(this.getValidationContext());
            ((ValidationStack)this.nextReceiver).setIsNilled(nilled);
            ((ValidationStack)this.nextReceiver).setXsiValidationErrors(this.xsiValidationErrors);
        }
        this.namespacesEncountered.add(nameCode.getURI());
        if (xsiType != null) {
            this.getValidationContext().setXSIType(xsiType);
        }
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
        if (xsiType != null) {
            this.getValidationContext().setXSIType(null);
        }
    }

    private void processXsiSchemaLocation(String value, Location locationId) throws XPathException {
        String tok;
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r", false);
        String targetNS = null;
        while (tokenizer.hasMoreTokens()) {
            boolean ignore;
            tok = tokenizer.nextToken();
            if (targetNS == null) {
                targetNS = tok;
                continue;
            }
            try {
                URI abs = ResolveURI.makeAbsolute(tok, this.getSystemId());
                ignore = abs.equals(this.schemaDocumentsRead.get(targetNS));
                this.schemaDocumentsRead.put(targetNS, abs);
            }
            catch (URISyntaxException err) {
                ignore = false;
            }
            if (!ignore) {
                if (this.namespacesEncountered.contains(targetNS) && this.getConfiguration().getXsdVersion() != 11) {
                    String message = "xsi:schemaLocation namespace " + Err.wrap(targetNS) + " has already appeared earlier in the instance document";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "schema-loc", "4");
                    this.reportValidationError(ve, false, locationId);
                }
                this.loadSchema(tok, targetNS);
            }
            targetNS = null;
        }
        if (targetNS != null) {
            String message = "xsi:schemaLocation must contain an even number of URIs";
            ValidationFailure ve = new ValidationFailure(message);
            this.reportValidationError(ve, false, locationId);
        }
        tokenizer = new StringTokenizer(value, " \t\n\r", false);
        targetNS = null;
        while (tokenizer.hasMoreTokens()) {
            tok = tokenizer.nextToken();
            if (targetNS == null) {
                targetNS = tok;
                continue;
            }
            this.getConfiguration().sealNamespace(targetNS);
            targetNS = null;
        }
    }

    private void processXsiNoNamespaceSchemaLocation(Location locationId, String value) throws XPathException {
        boolean ignore;
        try {
            URI abs = ResolveURI.makeAbsolute(value, this.getSystemId());
            ignore = abs.equals(this.schemaDocumentsRead.get(""));
            this.schemaDocumentsRead.put("", abs);
        }
        catch (URISyntaxException err) {
            ignore = false;
        }
        if (!ignore) {
            if (this.namespacesEncountered.contains("")) {
                String message = "xsi:noNamespaceSchemaLocation cannot appear after the first no-namespace element or attribute";
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "schema-loc", "4");
                this.reportValidationError(ve, false, locationId);
            }
            this.loadSchema(value, "");
        }
    }

    private boolean processXsiNil(String value) {
        ConversionResult v = StringConverter.StringToBoolean.INSTANCE.convertString(value);
        if (v instanceof ValidationFailure) {
            String message = "The value of xsi:nil must be a boolean";
            ValidationFailure ve = new ValidationFailure(message);
            this.xsiValidationErrors.add(ve);
        }
        return v == BooleanValue.TRUE;
    }

    private SchemaType processXsiType(String value) {
        block4: {
            Configuration config = this.getConfiguration();
            try {
                StructuredQName qName = StructuredQName.fromLexicalQName(value, true, false, this.getStartTagBuffer());
                SchemaType type = config.getSchemaType(qName);
                if (type == null) {
                    String message = "Unknown type " + Err.wrap(value) + " specified in xsi:type attribute";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-elt", "4.2");
                    this.xsiValidationErrors.add(ve);
                    break block4;
                }
                if (type instanceof ComplexType && ((ComplexType)type).isAbstract()) {
                    String message = "Type " + Err.wrap(value) + " specified in xsi:type attribute is abstract";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-type", "2");
                    this.xsiValidationErrors.add(ve);
                    break block4;
                }
                return type;
            }
            catch (XPathException de) {
                String message = "Invalid QName " + Err.wrap(value) + " specified in xsi:type attribute: " + de.getMessage();
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "4.1");
                this.xsiValidationErrors.add(ve);
            }
        }
        return null;
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        String uri = nameCode.getURI();
        if (uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            int fp = nameCode.obtainFingerprint(this.getNamePool());
            if (fp == 644) {
                typeCode = BuiltInAtomicType.ANY_URI;
            } else if (fp == 643) {
                typeCode = BuiltInListType.ANY_URIS;
            } else if (fp == 641) {
                typeCode = BuiltInAtomicType.QNAME;
            } else if (fp == 642) {
                typeCode = BuiltInAtomicType.BOOLEAN;
            }
        }
        this.namespacesEncountered.add(uri);
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void endDocument() throws XPathException {
        super.endDocument();
        this.reportIfInvalid();
    }

    private void loadSchema(String value, String targetNS) throws XPathException {
        int status = ((EnterpriseConfiguration)this.getConfiguration()).getNamespaceStatus(targetNS);
        if (status != 1 && status != 2) {
            return;
        }
        String href = Whitespace.trim(value);
        String base = this.getSystemId();
        PipelineConfiguration pipe = null;
        try {
            pipe = new PipelineConfiguration(this.getPipelineConfiguration());
            InvalidityHandler handler = this.getValidationContext().getInvalidityHandler();
            if (handler instanceof InvalidityHandlerWrappingErrorListener) {
                ErrorListener listener = ((InvalidityHandlerWrappingErrorListener)handler).getErrorListener();
                pipe.setErrorListener(listener);
            }
            EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
            config.readSchema(pipe, base, href, targetNS);
        }
        catch (SchemaException e) {
            try {
                pipe = new PipelineConfiguration(this.getPipelineConfiguration());
                EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
                SchemaCompiler compiler = config.newSchemaCompiler();
                compiler.setPreparedSchema(config.getSuperSchema());
                config.getSuperSchema().validate(compiler);
                UnfailingErrorListener el = pipe.getErrorListener();
                if (el instanceof StandardErrorListener && ((StandardErrorListener)el).getRecoveryPolicy() == 0) {
                    ((StandardErrorListener)el).setRecoveryPolicy(1);
                }
                pipe.getErrorListener().warning(e);
                pipe.getErrorListener().warning(new SchemaException("Validation will continue without the schema at " + value));
            }
            catch (SchemaException err) {
                throw XPathException.makeXPathException(e);
            }
        }
    }
}

