/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.XSDAny;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSDAnyAttribute
extends AnnotationParent {
    private AttributeWildcard wildcard = null;

    @Override
    public void prepareAttributes() throws SchemaException {
        this.wildcard = new AttributeWildcard(this.getSchema().getConfiguration());
        this.wildcard.setLocator(this);
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "namespace", "notNamespace", "notQName", "processContents"};
        this.allowAttributes(atts, allowed);
        this.checkMutuallyExclusiveAttributes("namespace", "notNamespace");
        String attValue = atts.getValue("", "namespace");
        if (attValue != null) {
            this.processAllowedNamespaces(attValue, this.wildcard.getWildcard());
        }
        if ((attValue = atts.getValue("", "notNamespace")) != null) {
            this.processDisallowedNamespaces(attValue, this.wildcard.getWildcard());
        }
        if ((attValue = atts.getValue("", "notQName")) != null) {
            this.processDisallowedQNames(attValue, this.wildcard.getWildcard());
        }
        if ((attValue = atts.getValue("", "processContents")) != null) {
            if (XSDAny.isProcessName(attValue)) {
                this.wildcard.getWildcard().setProcessContents(attValue);
            } else {
                this.invalidAttributeValue("processContents", attValue, null);
            }
        }
        this.processId();
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        super.validate(compiler);
        if (this.getAttributeValue("", "notNamespace") != null && compiler.getLanguageVersion() != 11) {
            this.error("The notNamespace attribute requires XSD 1.1 to be enabled");
        }
    }

    public AttributeWildcard getWildcard() {
        return this.wildcard;
    }
}

