/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.TypeAlternative;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.XSDAlternative;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDGroup;
import com.saxonica.ee.schema.sdoc.XSDIdentityConstraint;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.StringTokenizer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaException;

public class XSDElement
extends SchemaElement {
    private boolean foundTypeReference = false;
    private boolean isReference = false;
    private StructuredQName elementName;
    private ElementDecl element = null;
    private ElementParticle elementParticle = null;
    private static final int[] state0terms = new int[]{578, 621, 599, 588, 600, 625, 577};
    private static final int[] state0targets = new int[]{1, 2, 3, 2, 3, 3, 4};
    private static final int[] state1terms = new int[]{621, 599, 588, 600, 625, 577};
    private static final int[] state1targets = new int[]{2, 3, 2, 3, 3, 4};
    private static final int[] state2terms = new int[]{599, 600, 625, 577};
    private static final int[] state2targets = new int[]{3, 3, 3, 4};
    private static final int[] state3terms = new int[]{599, 600, 625};
    private static final int[] state3targets = new int[]{3, 3, 3};
    private static final int[] state4terms = new int[]{599, 600, 625, 577};
    private static final int[] state4targets = new int[]{3, 3, 3, 4};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets};

    @Override
    public void prepareAttributes() throws SchemaException {
        FastStringBuffer buff;
        StructuredQName nc;
        String attValue;
        String localTargetNamespace;
        String[] allowed;
        SingleNamespaceSchema schema = this.getSchema();
        AttributeCollection atts = this.getAttributeList();
        boolean bl = this.isReference = atts.getValue("", "ref") != null;
        if (this.isTopLevel()) {
            allowed = new String[]{"abstract", "block", "default", "final", "fixed", "id", "name", "nillable", "substitutionGroup", "type"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            allowed = new String[]{"block", "default", "fixed", "form", "id", "maxOccurs", "minOccurs", "name", "nillable", "ref", "targetNamespace", "type"};
            this.allowAttributes(atts, allowed);
        }
        String form = atts.getValue("", "form");
        if (form != null) {
            if (!form.equals("qualified") && !form.equals("unqualified")) {
                this.invalidAttributeValue("form", form, "Must be 'qualified' or 'unqualified'");
            }
        } else if (this.isTopLevel()) {
            form = "qualified";
        } else {
            form = this.getXSDSchema().getElementFormDefault();
            if (form == null) {
                form = "unqualified";
            }
        }
        if ((localTargetNamespace = atts.getValue("", "targetNamespace")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The targetNamespace cannot be defined locally unless XSD 1.1 is enabled");
            }
            if (atts.getValue("", "name") == null) {
                this.error("If there is no @name then there must be no @targetNamespace");
            }
            this.checkMutuallyExclusiveAttributes("targetNamespace", "form");
        }
        if ((attValue = atts.getValue("", "name")) != null) {
            this.element = new ElementDecl((EnterpriseConfiguration)this.getConfiguration(), this.isTopLevel(), this);
            this.element.setGeneratedId(Navigator.getPath(this));
            this.element.setNamespaceResolver(this.makeNamespaceContext());
            try {
                nc = localTargetNamespace != null || "qualified".equals(form) ? this.getComponentName(attValue, 1) : this.getComponentName(attValue, 2);
            }
            catch (SchemaException err) {
                nc = StandardNames.SQ_XS_INVALID_NAME;
                this.error(err.getMessage());
            }
            this.elementName = nc;
            this.element.setElementName(nc);
            if (!this.isTopLevel()) {
                this.elementParticle = new ElementParticle((EnterpriseConfiguration)this.getConfiguration(), this);
                this.elementParticle.setTargetComponentName(nc);
                this.elementParticle.setReference(this.element);
                schema.addComponent(this.elementParticle);
                if (atts.getValue("", "type") == null && !this.hasChildNodes() && !this.isReference) {
                    boolean existsAsTopLevel;
                    boolean bl2 = existsAsTopLevel = schema.getElementDecl(nc) != null;
                    if (!existsAsTopLevel) {
                        NodeInfo decl;
                        String localName = nc.getLocalPart();
                        XSDSchema s = this.getXSDSchema();
                        AxisIterator top = s.iterateAxis((byte)3, new NameTest(1, 591, this.getNamePool()));
                        while ((decl = top.next()) != null) {
                            if (!localName.equals(decl.getAttributeValue("", "name"))) continue;
                            existsAsTopLevel = true;
                        }
                    }
                    if (existsAsTopLevel) {
                        this.warning("Local element declaration matches the name of a global element, and allows any content. Did you mean to write ref='" + attValue + "' instead of name='" + attValue + "'? To suppress this warning, add type='xs:anyType'");
                    }
                }
            }
        } else if (!this.isReference) {
            this.error("Either the @name or the @ref attribute must be supplied");
        }
        attValue = atts.getValue("", "ref");
        if (attValue != null) {
            try {
                nc = this.getComponentName(attValue, 0);
            }
            catch (SchemaException err) {
                nc = StandardNames.SQ_XS_INVALID_NAME;
                this.error(err.getMessage());
            }
            this.elementName = nc;
            this.elementParticle = new ElementParticle((EnterpriseConfiguration)this.getConfiguration(), this);
            this.elementParticle.setTargetComponentName(nc);
            schema.addComponent(this.elementParticle);
            this.checkMutuallyExclusiveAttributes("ref", "name");
            this.checkMutuallyExclusiveAttributes("ref", "block");
            this.checkMutuallyExclusiveAttributes("ref", "default");
            this.checkMutuallyExclusiveAttributes("ref", "fixed");
            this.checkMutuallyExclusiveAttributes("ref", "form");
            this.checkMutuallyExclusiveAttributes("ref", "nillable");
            this.checkMutuallyExclusiveAttributes("ref", "type");
        }
        if (this.element == null && this.isTopLevel()) {
            this.element = new ElementDecl((EnterpriseConfiguration)this.getConfiguration(), this.isTopLevel(), this);
            buff = new FastStringBuffer(64);
            this.generateId(buff);
            this.element.setGeneratedId(buff.toString());
            this.element.setNamespaceResolver(new InscopeNamespaceResolver(this));
            this.element.setElementName(new StructuredQName("", "", "unnamed-error-element-at-line-" + this.getLineNumber()));
        }
        if (this.elementParticle == null && !this.isTopLevel()) {
            this.element = new ElementDecl((EnterpriseConfiguration)this.getConfiguration(), this.isTopLevel(), this);
            buff = new FastStringBuffer(64);
            this.generateId(buff);
            this.element.setGeneratedId(buff.toString());
            this.element.setNamespaceResolver(new InscopeNamespaceResolver(this));
            StructuredQName nameCode = new StructuredQName("", "", "unnamed-error-element-at-line-" + this.getLineNumber());
            this.element.setElementName(nameCode);
            this.elementParticle = new ElementParticle((EnterpriseConfiguration)this.getConfiguration(), this);
            this.elementParticle.setTargetComponentName(nameCode);
        }
        this.processId();
        if (this.element != null) {
            attValue = atts.getValue("", "abstract");
            if (attValue != null) {
                boolean isAbstract = this.parseBooleanAttribute("abstract", attValue);
                this.element.setAbstract(isAbstract);
            }
            if ((attValue = atts.getValue("", "block")) == null) {
                if (this.element != null) {
                    this.element.setBlock(this.getXSDSchema().getBlockDefault());
                }
            } else {
                int f = this.parseFinalOrBlock("block", attValue, 19);
                this.element.setBlock(f);
            }
            if ((attValue = atts.getValue("", "default")) != null) {
                this.element.setValueConstraint(new ValueConstraint(ValueConstraint.Variety.DEFAULT, attValue));
            }
            if ((attValue = atts.getValue("", "final")) == null) {
                if (this.element != null) {
                    this.element.setFinalProhibitions(this.getXSDSchema().getFinalDefault());
                }
            } else {
                int f = this.parseFinalOrBlock("final", attValue, 3);
                this.element.setFinalProhibitions(f);
            }
            if ((attValue = atts.getValue("", "fixed")) != null) {
                if (atts.getValue("", "default") != null) {
                    this.mutuallyExclusiveAttributes("default", "fixed");
                } else {
                    this.element.setValueConstraint(new ValueConstraint(ValueConstraint.Variety.FIXED, attValue));
                }
            }
            if ((attValue = atts.getValue("", "substitutionGroup")) != null) {
                StringTokenizer st = new StringTokenizer(attValue, " \t\r\n");
                while (st.hasMoreTokens()) {
                    String head = st.nextToken();
                    try {
                        StructuredQName qName = this.getComponentName(head, 0);
                        this.element.addSubstitutionGroupHead(qName);
                    }
                    catch (SchemaException err) {
                        this.error(err.getMessage());
                    }
                }
            }
            if ((attValue = atts.getValue("", "type")) != null) {
                this.foundTypeReference = true;
                try {
                    int fp = this.getFingerprint(attValue, 0);
                    this.checkPermittedType(fp, attValue, "an element type");
                    TypeReference ref = new TypeReference(fp, this.element.getConfiguration(), this);
                    this.element.setTypeReference(ref);
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                }
            }
            if ((attValue = atts.getValue("", "nillable")) != null) {
                boolean isNillable = this.parseBooleanAttribute("nillable", attValue);
                this.element.setNillable(isNillable);
            }
        }
        if (this.elementParticle != null) {
            attValue = atts.getValue("", "minOccurs");
            int minOccurs = 1;
            if (attValue != null) {
                minOccurs = this.processMinOccurs(attValue);
                this.elementParticle.setMinOccurs(minOccurs);
            }
            if ((attValue = atts.getValue("", "maxOccurs")) != null) {
                int maxOccurs = this.processMaxOccurs(attValue);
                if (maxOccurs >= 0 && maxOccurs < minOccurs) {
                    this.error("maxOccurs is less than minOccurs");
                }
                this.elementParticle.setMaxOccurs(maxOccurs);
            } else {
                if (minOccurs > 0) {
                    this.elementParticle.setMaxOccurs(minOccurs);
                } else {
                    this.elementParticle.setMaxOccurs(1);
                }
                int maxOccurs = this.elementParticle.getMaxOccurs();
                if (maxOccurs != -1 && this.elementParticle.getMinOccurs() > maxOccurs) {
                    this.error("maxOccurs must not be less than minOccurs");
                }
            }
        }
    }

    public ElementDecl getElementDeclaration() {
        return this.element;
    }

    public ElementParticle getElementParticle() {
        return this.elementParticle;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        String localTargetNamespace = this.getAttributeValue("", "targetNamespace");
        if (localTargetNamespace != null && !localTargetNamespace.equals(this.getXSDSchema().getTargetNamespace())) {
            this.checkLocalTargetNamespace("element");
        }
        this.checkContentModel(stateTerms, stateTargets, false);
        if (this.element != null) {
            NodeInfo anc;
            AxisIterator ancIter = this.iterateAxis((byte)0);
            while ((anc = ancIter.next()) != null) {
                if (anc instanceof XSDComplexType) {
                    this.element.setContainingComplexType(((XSDComplexType)anc).getComplexType());
                    break;
                }
                if (!(anc instanceof XSDGroup)) continue;
                this.element.setContainingModelGroup(((XSDGroup)anc).getGroupDeclaration());
                break;
            }
        }
        XSDAlternative lastAlternative = null;
        AxisIterator iter = this.iterateAxis((byte)3);
        block8: while ((child = (NodeImpl)iter.next()) != null) {
            String childName = child.getLocalPart();
            int childfp = child.getFingerprint();
            switch (childfp) {
                case 578: {
                    continue block8;
                }
                case 588: {
                    if (this.isReference) {
                        this.mutuallyExclusiveElementAndAttribute("complexType", "ref");
                    }
                    if (!this.foundTypeReference) continue block8;
                    this.mutuallyExclusiveElementAndAttribute("complexType", "type");
                    continue block8;
                }
                case 621: {
                    if (this.isReference) {
                        this.mutuallyExclusiveElementAndAttribute("simpleType", "ref");
                    }
                    if (!this.foundTypeReference) continue block8;
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "type");
                    continue block8;
                }
                case 577: {
                    if (this.isReference) {
                        this.mutuallyExclusiveElementAndAttribute("alternative", "ref");
                    }
                    if (compiler.getLanguageVersion() == 10) {
                        this.error("Conditional Type Assignment requires XML Schema 1.1 to be enabled");
                        return;
                    }
                    if (lastAlternative != null && lastAlternative.getTypeAlternative().getCondition() == null) {
                        lastAlternative.error("The test attribute is required on all alternatives except the last");
                    }
                    lastAlternative = (XSDAlternative)child;
                    continue block8;
                }
                case 599: 
                case 600: 
                case 625: {
                    if (!this.isReference) continue block8;
                    this.mutuallyExclusiveElementAndAttribute(childName, "ref");
                    continue block8;
                }
            }
            this.illegalElement(child);
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3 || state == 4;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        if (this.isReference) {
            return;
        }
        TypeAlternative lastAlternative = null;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int childfp = child.getFingerprint();
            switch (childfp) {
                case 588: {
                    UserDefinedType schemaType = ((XSDComplexType)child).getComplexType();
                    TypeReference ref = new TypeReference(schemaType.getFingerprint(), this.element.getConfiguration(), child);
                    ref.setTarget(schemaType);
                    this.element.setTypeReference(ref);
                    schemaType.setContainingDeclaration(this.elementName, true);
                    break;
                }
                case 621: {
                    UserDefinedType schemaType = ((XSDSimpleType)child).getSimpleTypeDefinition();
                    TypeReference ref = new TypeReference(schemaType.getFingerprint(), this.element.getConfiguration(), child);
                    ref.setTarget(schemaType);
                    this.element.setTypeReference(ref);
                    schemaType.setContainingDeclaration(this.elementName, true);
                    ((UserSimpleType)schemaType).setContextComponent(this.element);
                    break;
                }
                case 577: {
                    lastAlternative = ((XSDAlternative)child).getTypeAlternative();
                    this.element.addTypeAlternative(lastAlternative);
                    break;
                }
                case 599: 
                case 600: 
                case 625: {
                    IdentityConstraintReference constraint = ((XSDIdentityConstraint)child).getIdentityConstraint();
                    this.element.addIdentityConstraint(constraint);
                    break;
                }
            }
            if (lastAlternative == null || lastAlternative.getCondition() == null) continue;
            EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
            lastAlternative = new TypeAlternative(config, null, null);
            int typeRef = this.element.getTypeFingerprint();
            if (typeRef == -1) {
                typeRef = 572;
            }
            lastAlternative.setTypeReference(new TypeReference(typeRef, config, this.element));
            lastAlternative.setLocator(this);
        }
    }
}

