/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.SpanRepetitionQuery;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSequenceQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import org.apache.lucene.search.spans.SpanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanRepetitionQueryWrapper
extends SpanQueryWrapper {
    private SpanQueryWrapper subquery;
    private static final Logger log = LoggerFactory.getLogger(SpanSequenceQueryWrapper.class);

    public SpanRepetitionQueryWrapper() {
        this.isEmpty = true;
        this.isNull = false;
    }

    public SpanRepetitionQueryWrapper(SpanQueryWrapper subquery, int exact) {
        if (!subquery.isEmpty()) {
            this.subquery = subquery;
            this.maybeUnsorted = subquery.maybeUnsorted();
            this.isEmpty = false;
        } else {
            this.isEmpty = true;
        }
        if (exact < 1 || this.subquery.isNull()) {
            this.isNull = true;
            this.isOptional = true;
            this.min = 0;
            this.max = 0;
            return;
        }
        this.isNull = false;
        this.min = exact;
        this.max = exact;
    }

    public SpanRepetitionQueryWrapper(SpanQueryWrapper subquery, int min, int max) {
        if (!subquery.isEmpty()) {
            this.subquery = subquery;
            if (subquery.maybeUnsorted()) {
                this.maybeUnsorted = true;
            }
        } else {
            this.isEmpty = true;
        }
        if (subquery.isNull()) {
            this.isNull = true;
            return;
        }
        this.isNull = false;
        if (min == 0) {
            this.isOptional = true;
            min = 1;
            if (max == 0) {
                this.isNull = true;
            }
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        if (this.isNull) {
            return null;
        }
        if (this.isEmpty) {
            log.error("You can't queryize an empty query");
            return null;
        }
        if (this.min == 1 && this.max == 1) {
            return this.subquery.retrieveNode(this.retrieveNode).toFragmentQuery();
        }
        return new SpanRepetitionQuery(this.subquery.retrieveNode(this.retrieveNode).toFragmentQuery(), this.min, this.max, true);
    }

    @Override
    public boolean isNegative() {
        if (this.subquery == null) {
            return false;
        }
        return this.subquery.isNegative();
    }
}

