/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class Projector
extends ProxyReceiver {
    private Stack pathPositionStack;
    private Stack isCopiedStack;
    private int level = 0;
    private int copyAllLevel = Integer.MAX_VALUE;
    private int inputNodes = 0;
    private int outputNodes = 0;
    private boolean displayStatistics = false;
    private NamespaceBinding[] nsStack = new NamespaceBinding[20];
    private int nsStackTop = 0;
    private int[] nsCountStack = new int[20];

    public Projector(PathMap.PathMapRoot pathMapRoot, Receiver next) {
        super(next);
        this.pathPositionStack = new Stack();
        this.isCopiedStack = new Stack();
        this.pathPositionStack.push(new PathMap.PathMapNodeSet(pathMapRoot));
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.displayStatistics = pipe.getConfiguration().isTiming();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        ++this.level;
        ++this.inputNodes;
        boolean elementCopied = false;
        if (this.level > this.copyAllLevel) {
            super.startElement(elemName, typeCode, location, properties);
            elementCopied = true;
            this.pathPositionStack.push("dummy");
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            PathMap.PathMapNodeSet newState = new PathMap.PathMapNodeSet();
            boolean foundMatch = false;
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (test.matches(1, elemName, typeCode)) {
                        foundMatch = true;
                        PathMap.PathMapNode target = arc.getTarget();
                        newState.add(target);
                        if (target.isAtomized() || target.isReturnable()) {
                            this.copyAllLevel = this.level;
                        }
                    }
                    if (arc.getAxis() != 4) continue;
                    newState.add(aState);
                }
            }
            this.pathPositionStack.push(newState);
            if (foundMatch) {
                super.startElement(elemName, typeCode, location, properties);
                elementCopied = true;
            }
        }
        if (elementCopied) {
            int i;
            ++this.outputNodes;
            int pendingNamespaces = 0;
            for (i = this.level - 2; i >= 0 && !((Boolean)this.isCopiedStack.get(i)).booleanValue(); --i) {
                pendingNamespaces += this.nsCountStack[i];
            }
            for (i = this.nsStackTop - pendingNamespaces; i < this.nsStackTop; ++i) {
                boolean duplicate = false;
                for (int j = i + 1; j < this.nsStackTop; ++j) {
                    if (!this.nsStack[j].getPrefix().equals(this.nsStack[i].getPrefix())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                super.namespace(this.nsStack[i], 0);
            }
        }
        this.isCopiedStack.push(elementCopied);
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            ++this.outputNodes;
        } else if (((Boolean)this.isCopiedStack.peek()).booleanValue()) {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(2, nameCode, typeCode)) continue;
                    super.attribute(nameCode, typeCode, value, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (((Boolean)this.isCopiedStack.peek()).booleanValue()) {
            super.namespace(namespaceBindings, properties);
        } else {
            for (NamespaceBinding ns : namespaceBindings) {
                if (this.nsStack.length <= this.nsStackTop) {
                    this.nsStack = Arrays.copyOf(this.nsStack, this.nsStack.length * 2);
                }
                this.nsStack[this.nsStackTop++] = ns;
                int n = this.level - 1;
                this.nsCountStack[n] = this.nsCountStack[n] + 1;
            }
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level >= this.copyAllLevel) {
            super.characters(chars, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = pathNode.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(3, null, null)) continue;
                    super.characters(chars, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.comment(chars, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(8, null, null)) continue;
                    super.comment(chars, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.processingInstruction(target, data, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = (PathMap.PathMapNodeSet)this.pathPositionStack.peek();
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(7, new NoNamespaceName(target), null)) continue;
                    super.processingInstruction(target, data, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void endElement() throws XPathException {
        boolean wasCopied = (Boolean)this.isCopiedStack.pop();
        if (wasCopied) {
            super.endElement();
        }
        this.pathPositionStack.pop();
        --this.level;
        if (this.level < this.copyAllLevel) {
            this.copyAllLevel = Integer.MAX_VALUE;
        }
        this.nsStackTop -= this.nsCountStack[this.level];
        this.nsCountStack[this.level] = 0;
    }

    @Override
    public void endDocument() throws XPathException {
        if (this.displayStatistics) {
            this.outputStatistics(System.err);
        }
        super.endDocument();
    }

    public void outputStatistics(PrintStream out) {
        out.println("Document projection for " + this.getSystemId());
        out.println("-- Input nodes " + this.inputNodes + "; output nodes " + this.outputNodes + "; reduction = " + (100 - 100 * this.outputNodes / this.inputNodes) + "%");
    }
}

