/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.czech;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import marmot.morph.mapper.Node;
import marmot.morph.mapper.SyntaxTree;
import marmot.morph.mapper.SyntaxTreeIterator;
import marmot.morph.mapper.czech.MsdTag;
import marmot.morph.mapper.czech.PdTMsdMapper;
import marmot.morph.mapper.czech.PdtMorphTag;
import marmot.morph.mapper.czech.PdtMorphTagReader;
import marmot.util.Counter;
import marmot.util.FileUtils;

public class ConllReader {
    public static void main(String[] args2) throws IOException {
        for (String filename : args2) {
            SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(filename, 1, 2, 4, 6, 8, 10, false);
            File file = new File(filename);
            String outfile = file.getName() + ".converted";
            if ((file = new File(outfile)).exists()) {
                System.err.println("Error: Outfile already exists: " + file.getAbsolutePath());
                System.exit(1);
            }
            Writer writer = FileUtils.openFileWriter(outfile);
            PdTMsdMapper mapper = new PdTMsdMapper();
            while (iterator2.hasNext()) {
                SyntaxTree tree = iterator2.next();
                for (Node node : tree.getNodes()) {
                    String pos = node.getPos();
                    String feats = node.getFeats();
                    try {
                        PdtMorphTag tag = ConllReader.parse(pos, feats);
                        MsdTag new_tag = mapper.map(tag);
                        node.setMorphTag(new_tag);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e + " " + pos + " " + feats);
                    }
                }
                tree.write(writer);
                writer.write(10);
            }
            writer.close();
        }
    }

    private static PdtMorphTag parse(String pos, String feats) {
        PdtMorphTagReader reader = new PdtMorphTagReader();
        return reader.parse_keyvalue(pos, feats);
    }

    public static Map<String, Counter<String>> getDict(String ptb_file) {
        HashMap<String, Counter<String>> map2 = new HashMap<String, Counter<String>>();
        SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(ptb_file, 1, 2, 4, 6, 8, 10, false);
        PdTMsdMapper mapper = new PdTMsdMapper();
        while (iterator2.hasNext()) {
            SyntaxTree tree = iterator2.next();
            for (Node node : tree.getNodes()) {
                String pos = node.getPos();
                String feats = node.getFeats();
                PdtMorphTag tag = ConllReader.parse(pos, feats);
                MsdTag new_tag = mapper.map(tag);
                Counter counter = map2.computeIfAbsent(node.getForm(), k -> new Counter());
                counter.increment(new_tag.toHumanString(), 1.0);
            }
        }
        return map2;
    }
}

