<xsl:stylesheet version="3.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:saxon="http://saxon.sf.net/"
                exclude-result-prefixes="saxon">
    
    <xsl:output method="xml" indent="yes" saxon:line-length="1000"
                doctype-public="-//IDS//DTD IDS-I5 1.0//EN"
                doctype-system="http://corpora.ids-mannheim.de/I5/DTD/i5.dtd"
        />
    
    <xsl:mode streamable="yes" on-no-match="shallow-copy"/> 
    <xsl:mode streamable="no" on-no-match="shallow-copy" name="no-Streaming"/>
    <!-- <xsl:template match="idsDoc[not(normalize-space(.//body))]"/> -->
    
    <!-- <xsl:template match="idsText[not(normalize-space(.//body))]"/>-->

    <xsl:template match="idsText">
        <xsl:variable name="idsText" as="node()">
            <xsl:copy-of select="."/>
        </xsl:variable>
        <xsl:if test="normalize-space($idsText//body)">
            <xsl:apply-templates select="$idsText" mode="no-Streaming"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="hi[parent::div]" priority="0.6" mode="no-Streaming">
        <p>
            <xsl:apply-templates mode="no-Streaming"/>
        </p>
    </xsl:template>
    
    <xsl:template match="(ref|emph|hi|text())[parent::div]" priority="0.9" mode="no-Streaming">
        <p>
            <xsl:apply-templates mode="no-Streaming"/>
        </p>
    </xsl:template>

    <xsl:template match="p/div" mode="no-Streaming">
        <xsl:apply-templates mode="no-Streaming"/>
    </xsl:template>

    <xsl:template match="p/p" mode="no-Streaming">
        <xsl:apply-templates mode="no-Streaming"/>
    </xsl:template>

    <xsl:template match="hi[local-name(preceding-sibling::*[1]) = 'hi' and @rend = preceding-sibling::hi[1]/@rend]" mode="no-Streaming"/>

    <xsl:template match="hi[following-sibling::hi and not(preceding-sibling::hi)]" mode="no-Streaming">
        <xsl:variable name="rend" select="@rend"/>
        <hi rend="{$rend}">
            <xsl:for-each-group select="self|following-sibling::hi" group-adjacent="@rend=$rend">
                <xsl:value-of select="current-group()"/>
            </xsl:for-each-group>
        </hi>
    </xsl:template>
</xsl:stylesheet>
