/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.EvalitaNameSampleStream;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class EvalitaNameSampleStreamFactory<P>
extends LanguageSampleStreamFactory<NameSample, P> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "evalita", new EvalitaNameSampleStreamFactory<Parameters>(Parameters.class));
    }

    protected EvalitaNameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args2) {
        Parameters params = ArgumentParser.parse(args2, Parameters.class);
        if (!"it".equals(params.getLang())) {
            throw new TerminateToolException(1, "Unsupported language: " + params.getLang());
        }
        EvalitaNameSampleStream.LANGUAGE lang = EvalitaNameSampleStream.LANGUAGE.IT;
        this.language = params.getLang();
        int typesToGenerate = 0;
        String types = params.getTypes();
        if (types.contains("per")) {
            typesToGenerate |= 1;
        }
        if (types.contains("org")) {
            typesToGenerate |= 2;
        }
        if (types.contains("loc")) {
            typesToGenerate |= 4;
        }
        if (types.contains("gpe")) {
            typesToGenerate |= 8;
        }
        try {
            return new EvalitaNameSampleStream(lang, CmdLineUtil.createInputStreamFactory(params.getData()), typesToGenerate);
        }
        catch (IOException e) {
            throw CmdLineUtil.createObjectStreamError(e);
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="it")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,gpe")
        public String getTypes();
    }
}

