/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.AutomatonState;
import com.saxonica.ee.schema.fsa.Edge;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import com.saxonica.ee.schema.fsa.State;
import com.saxonica.ee.schema.fsa.SuffixState;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.LaxValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public class ComplexContentValidator
extends AttributeValidator {
    private UserComplexType type;
    private boolean mixed;
    private UnicodeString fixedValue = null;
    private UnicodeString defaultValue = null;
    private State state;
    private int previousElement = -1;
    private boolean ignoreIgnorable;
    private UnicodeBuilder buffer;
    private boolean foundChildren = false;

    public ComplexContentValidator(ElementDecl declaration, UserComplexType type, Receiver next) throws MissingComponentException {
        super(next);
        this.setSchemaType(type);
        if (declaration != null) {
            this.defaultValue = declaration.getDefaultValueLexicalForm();
            AtomicSequence fixed = declaration.getFixedValue();
            if (fixed != null) {
                this.fixedValue = fixed.getUnicodeStringValue();
            }
        }
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.ignoreIgnorable = this.getConfiguration().getParseOptions().getSpaceStrippingRule() != NoElementsSpaceStrippingRule.getInstance();
    }

    public void setSchemaType(UserComplexType type) throws MissingComponentException {
        this.type = type;
        this.mixed = type.isMixedContent();
        this.state = type.getInitialState();
        this.setAnnotation(type);
        this.setAttributeGroup(type.getCombinedAttributeGroup());
    }

    @Override
    public SchemaType getSchemaType() {
        return this.type;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType elemType, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        SchemaType annotation;
        if (this.locallyInvalid) {
            this.recover(elemName, attributes, namespaces, location, properties);
            return;
        }
        if (this.fixedValue != null) {
            String message = "Element " + Err.wrap(elemName.getDisplayName(), 1) + " cannot appear here, because the containing " + this.getContainingElementName() + " element has fixed content";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-elt", "5.2.2.1");
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, location);
            this.locallyInvalid = true;
            this.recover(elemName, attributes, namespaces, location, properties);
            return;
        }
        this.foundChildren = true;
        int fingerprint = elemName.obtainFingerprint(this.getNamePool());
        Edge edge = this.state.getTransition(fingerprint, this.type);
        if (edge == null) {
            FiniteStateMachine machine = this.type.getFiniteStateMachine();
            Wildcard openContentWildcard = machine.getOpenContentWildcard();
            if (openContentWildcard != null && openContentWildcard.matches(elemName, true, this.getConfiguration(), this.type)) {
                if (machine.isOpenContentInterleaved()) {
                    this.childValidator = new LaxValidator(this.getNextReceiver());
                    SchemaType annotation2 = this.processWildcardTerm(openContentWildcard, elemName, location);
                    super.startElement(elemName, annotation2, attributes, namespaces, location, properties);
                    return;
                }
                if (this.state.isFinalState()) {
                    this.state = SuffixState.getInstance();
                    this.childValidator = new LaxValidator(this.getNextReceiver());
                    SchemaType annotation3 = this.processWildcardTerm(openContentWildcard, elemName, location);
                    super.startElement(elemName, annotation3, attributes, namespaces, location, properties);
                    return;
                }
            }
            String message = this.supplyReasonForNonMatch(elemName);
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.4");
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, location);
            this.locallyInvalid = true;
            this.recover(elemName, attributes, namespaces, location, properties);
            return;
        }
        try {
            this.previousElement = fingerprint;
            this.state = edge.makeTransition(this.state);
        }
        catch (ValidationException e) {
            String message = e.getMessage();
            if (this.getContainingElement() != null) {
                message = "In content of " + this.getContainingElementName() + ": " + message;
            }
            ValidationFailure ve = e.getValidationFailure();
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, location);
            this.locallyInvalid = true;
            this.recover(elemName, attributes, namespaces, location, properties);
            return;
        }
        Term term = edge.getTerm();
        if (term instanceof ElementDecl) {
            ElementDecl decl = (ElementDecl)term;
            this.makeChildValidator(decl, elemName.getStructuredQName(), location, 0);
            this.childValidator.setContainingElement(decl.getComponentName(), location);
            annotation = this.childValidator.getAnnotation();
        } else {
            Wildcard card = (Wildcard)term;
            annotation = this.processWildcardTerm(card, elemName, location);
            if (this.childValidator == null) {
                this.childValidator = new LaxValidator(this.getNextReceiver());
            }
        }
        super.startElement(elemName, annotation, attributes, namespaces, location, properties);
    }

    private String supplyReasonForNonMatch(NodeName nodeName) {
        AutomatonState s;
        Object possibleOmissions;
        StructuredQName firstOmission;
        int fingerprint = nodeName == null ? -1 : nodeName.obtainFingerprint(this.getNamePool());
        StringBuilder fsb = new StringBuilder(64);
        if (this.getContainingElement() != null) {
            fsb.append("In content of ").append(this.getContainingElementName()).append(": ");
        }
        boolean explained = false;
        if (nodeName == null) {
            if (this.previousElement == -1) {
                fsb.append("Empty content is not allowed. ");
            } else {
                fsb.append("The content is incomplete. ");
                try {
                    firstOmission = null;
                    possibleOmissions = new HashSet();
                    for (Edge edge : this.state.getEdges()) {
                        if (!(edge.getParticle() instanceof ElementParticle)) continue;
                        StructuredQName omission2 = edge.getParticle().getTargetComponentName();
                        int omittedfp = ((ElementParticle)edge.getParticle()).getDeclaration().getFingerprint();
                        s = this.state.getTransition(omittedfp, this.type).getTargetState();
                        if (!s.isFinalState()) continue;
                        ((HashSet)possibleOmissions).add(omission2);
                        if (firstOmission != null) continue;
                        firstOmission = omission2;
                    }
                    if (!((HashSet)possibleOmissions).isEmpty()) {
                        if (((HashSet)possibleOmissions).size() == 1) {
                            fsb.append("It would be valid if followed by ").append(Err.wrap(firstOmission.getEQName(), 1)).append(". ");
                        } else if (((HashSet)possibleOmissions).size() > 5) {
                            fsb.append("It would be valid if followed by another element, for example ").append(Err.wrap(firstOmission.getEQName(), 1)).append(". ");
                        } else {
                            fsb.append("It would be valid if followed by one of: ");
                            boolean first = true;
                            Iterator iterator = ((HashSet)possibleOmissions).iterator();
                            while (iterator.hasNext()) {
                                StructuredQName poss = (StructuredQName)iterator.next();
                                if (!first) {
                                    fsb.append(", ");
                                }
                                fsb.append(Err.wrap(poss.getEQName(), 1));
                                first = false;
                            }
                            fsb.append(". ");
                        }
                        explained = true;
                    }
                }
                catch (MissingComponentException omission2) {}
            }
        } else if (this.state instanceof SuffixState) {
            fsb.append("The content model does not allow element ").append(Err.wrap(nodeName.getStructuredQName().getDisplayName(), 1)).append(" to appear after an element that matches the suffix open content wildcard. ");
            explained = true;
        } else {
            String s2;
            Wildcard openContentWildcard;
            fsb.append("The content model does not allow element ");
            fsb.append(Err.wrap(nodeName.getStructuredQName().getDisplayName(), 1));
            if (this.previousElement == -1) {
                fsb.append(" to appear as the first child. ");
            } else if (this.previousElement == fingerprint) {
                try {
                    if (Cardinality.allowsMany(this.type.getElementParticleCardinality(fingerprint, false))) {
                        fsb.append(" to appear this many times. ");
                    } else {
                        fsb.append(" to appear more than once. ");
                    }
                }
                catch (MissingComponentException e3) {
                    fsb.append(" to appear more than once. ");
                }
                explained = true;
            } else {
                fsb.append(" to appear immediately after element ");
                fsb.append(Err.wrap(this.getNamePool().getDisplayName(this.previousElement), 1));
                fsb.append(". ");
            }
            try {
                if (!explained && this.type.getElementParticleType(fingerprint, false) != null) {
                    firstOmission = null;
                    possibleOmissions = new HashSet();
                    for (Edge edge : this.state.getEdges()) {
                        if (!(edge.getParticle() instanceof ElementParticle)) continue;
                        StructuredQName omission3 = edge.getParticle().getTargetComponentName();
                        int omittedfp = ((ElementParticle)edge.getParticle()).getDeclaration().getFingerprint();
                        s = this.state.getTransition(omittedfp, this.type).getTargetState();
                        if (s.getTransition(fingerprint, this.type) == null) continue;
                        ((HashSet)possibleOmissions).add(omission3);
                        if (firstOmission != null) continue;
                        firstOmission = omission3;
                    }
                    if (!((HashSet)possibleOmissions).isEmpty()) {
                        if (((HashSet)possibleOmissions).size() == 1) {
                            fsb.append("It must be preceded by ").append(Err.wrap(firstOmission.getEQName(), 1)).append(". ");
                        } else if (((HashSet)possibleOmissions).size() > 5) {
                            fsb.append("It must be preceded by another element, for example ").append(Err.wrap(firstOmission.getEQName(), 1)).append(". ");
                        } else {
                            fsb.append("It must be preceded by one of: ");
                            boolean first = true;
                            Iterator iterator = ((HashSet)possibleOmissions).iterator();
                            while (iterator.hasNext()) {
                                StructuredQName poss = (StructuredQName)iterator.next();
                                if (!first) {
                                    fsb.append(", ");
                                }
                                if (poss.hasURI(nodeName.getNamespaceUri())) {
                                    fsb.append(Err.wrap(poss.getLocalPart(), 1));
                                } else {
                                    fsb.append(Err.wrap(poss.getEQName(), 1));
                                }
                                first = false;
                            }
                            fsb.append(". ");
                        }
                        explained = true;
                    }
                }
            }
            catch (MissingComponentException omission3) {
                // empty catch block
            }
            if (!explained) {
                String foundLocal = nodeName.getLocalPart();
                NamespaceUri foundURI = nodeName.getNamespaceUri();
                for (Edge e4 : this.state.getEdges()) {
                    String string;
                    if (!(e4.getParticle() instanceof ElementParticle) || !(string = ((ElementParticle)e4.getParticle()).getName()).equals(foundLocal)) continue;
                    NamespaceUri uri = ((ElementParticle)e4.getParticle()).getNamespaceURI();
                    fsb.append("The element is in ").append(foundURI.isEmpty() ? "no namespace" : "namespace " + foundURI).append(" but it should be in ").append(uri.isEmpty() ? "no namespace" : "namespace " + uri).append(". ");
                    explained = true;
                    break;
                }
            }
            if (!explained && (openContentWildcard = this.type.getOpenContentWildcard()) != null && (s2 = openContentWildcard.reasonForNonMatch(nodeName, true, this.getConfiguration(), this.type)) != null) {
                fsb.append("It does not match the open content wildcard: ");
                fsb.append(s2);
            }
        }
        if (!explained) {
            HashSet<String> specificTransitions = new HashSet<String>();
            StructuredQName expected = null;
            HashSet<NamespaceUri> specificURIs = new HashSet<NamespaceUri>();
            NamespaceUri namespace = null;
            for (Edge e5 : this.state.getEdges()) {
                if (!(e5.getParticle() instanceof ElementParticle)) continue;
                expected = e5.getParticle().getTargetComponentName();
                specificTransitions.add(((ElementParticle)e5.getParticle()).getDisplayName());
                namespace = ((ElementParticle)e5.getParticle()).getNamespaceURI();
                specificURIs.add(namespace);
            }
            HashSet<Wildcard> hashSet = new HashSet<Wildcard>();
            for (Edge e6 : this.state.getEdges()) {
                if (!(e6.getParticle() instanceof ElementWildcard)) continue;
                hashSet.add(((ElementWildcard)e6.getParticle()).getWildcard());
            }
            if (specificTransitions.isEmpty() && hashSet.isEmpty()) {
                if (this.previousElement == -1) {
                    fsb.append("In fact, nothing is allowed: the type has no valid instances. ");
                } else {
                    fsb.append("No further elements are allowed at this point. ");
                }
            } else {
                if (!specificTransitions.isEmpty()) {
                    if (specificTransitions.size() == 1) {
                        fsb.append("Expected ");
                        fsb.append(Err.wrap(expected.getEQName(), 1));
                        if (this.state.isFinalState()) {
                            fsb.append(" or nothing");
                        }
                        fsb.append(". ");
                    } else {
                        boolean uniform = specificURIs.size() == 1;
                        fsb.append("The following elements would be valid here");
                        if (uniform) {
                            fsb.append(", all in ");
                            fsb.append(namespace.isEmpty() ? "no namespace" : "namespace " + namespace);
                        }
                        fsb.append(": ");
                        int i = 0;
                        for (String s3 : specificTransitions) {
                            if (i >= 10) {
                                fsb.append(", and ").append(specificTransitions.size() - 10).append(" others");
                                break;
                            }
                            if (i++ > 0) {
                                fsb.append(", ");
                            }
                            if (uniform) {
                                int c = s3.indexOf(58);
                                if (c < 0) {
                                    fsb.append(s3);
                                    continue;
                                }
                                fsb.append(s3.substring(c + 1));
                                continue;
                            }
                            fsb.append(s3);
                        }
                        if (this.state.isFinalState()) {
                            fsb.append(" (or nothing)");
                        }
                        fsb.append(". ");
                    }
                }
                if (nodeName == null) {
                    if (!hashSet.isEmpty()) {
                        if (!specificTransitions.isEmpty()) {
                            fsb.append("Alternatively, an element that matches ");
                        } else {
                            fsb.append("Expected an element that matches ");
                        }
                        if (hashSet.size() == 1) {
                            fsb.append("the");
                        } else {
                            fsb.append("an");
                        }
                        fsb.append(" <xs:any> wildcard. ");
                    }
                } else if (hashSet.size() == 1) {
                    for (Wildcard w : hashSet) {
                        fsb.append("There is an <xs:any> wildcard, but it does not match: ");
                        fsb.append(w.reasonForNonMatch(nodeName, true, this.getConfiguration(), this.type));
                    }
                } else if (hashSet.size() > 1) {
                    fsb.append("There are several <xs:any> wildcards, but none of them match. ");
                }
            }
        }
        return fsb.toString();
    }

    private void recover(NodeName elemName, AttributeMap attributes, NamespaceMap namespaces, Location locationId, int properties) throws XPathException {
        this.childValidator = null;
        SchemaType childType = this.type.getContextDeterminedTypeForElement(elemName.getStructuredQName());
        if (!(childType == null || childType.isComplexType() && ((ComplexType)childType).isAbstract())) {
            ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
            this.childValidator = ComplexContentValidator.makeValidator(null, elemName.getStructuredQName(), locationId, this.getValidationContext(), childType, 8, this.getPipelineConfiguration(), this.nextReceiver, failures);
            for (ValidationFailure failure : failures) {
                this.reportValidationError(failure, false, locationId);
            }
        }
        if (this.childValidator == null) {
            childType = AnyType.getInstance();
            this.childValidator = new AnyTypeValidator(this.nextReceiver);
        }
        this.nextReceiver.startElement(elemName, childType, attributes, namespaces, locationId, properties);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return this.childValidator;
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        if (this.mixed) {
            if (this.fixedValue != null || this.defaultValue != null) {
                if (this.buffer == null) {
                    this.buffer = new UnicodeBuilder();
                }
                this.buffer.accept(chars);
            }
            this.nextReceiver.characters(chars, locationId, properties);
        } else if (Whitespace.isAllWhite(chars)) {
            if (!this.ignoreIgnorable) {
                this.nextReceiver.characters(chars, locationId, properties);
            }
        } else {
            String message = "The content model for " + this.getContainingElementName() + " does not allow character content";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setSchemaType(this.type);
            ve.setConstraintReference(1, "cvc-complex-type", "2.3");
            this.reportValidationError(ve, true, locationId);
        }
    }

    @Override
    public void endElement() throws XPathException {
        ValidationFailure ve;
        String message;
        if (this.fixedValue != null) {
            if (this.isNilled()) {
                String message2 = "The " + this.getContainingElementName() + " has a fixed value so it must not be nil";
                ValidationFailure ve2 = new ValidationFailure(message2);
                ve2.setConstraintReference(1, "cvc-elt", "3.2.2");
                ve2.setSchemaType(this.type);
                this.reportValidationError(ve2, true, this.getContainingElementLocationId());
                this.nextReceiver.endElement();
                return;
            }
            if (this.buffer == null || this.buffer.isEmpty()) {
                this.characters(this.fixedValue, Loc.NONE, 0);
            } else if (!this.buffer.toUnicodeString().equals(this.fixedValue)) {
                message = "The content of " + this.getContainingElementName() + " differs from the fixed value defined in the schema. Fixed value is " + Err.wrap(this.fixedValue, 4) + ", actual value is " + Err.wrap(this.buffer.toString(), 4);
                ve = new ValidationFailure(message);
                ve.setSchemaType(this.type);
                ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
            }
        }
        if (this.defaultValue != null && !this.foundChildren && (this.buffer == null || this.buffer.isEmpty())) {
            this.characters(this.defaultValue, Loc.NONE, 0);
        }
        if (!(this.state.isFinalState() || this.isNilled() || this.locallyInvalid)) {
            message = this.supplyReasonForNonMatch(null);
            ve = new ValidationFailure(message);
            ve.setSchemaType(this.type);
            ve.setConstraintReference(1, "cvc-complex-type", "2.4");
            this.reportValidationError(ve, true, this.getContainingElementLocationId());
        }
        this.nextReceiver.endElement();
    }
}

