/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import java.util.ArrayList;
import java.util.HashSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class GeneralComparisonEE
extends GeneralComparison {
    public GeneralComparisonEE(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.singletonOperator == 50 && !(this.getParentExpression() instanceof FilterExpression)) {
            Expression rhs;
            Expression lhs = this.getLhsExpression();
            Expression e2 = this.tryIndexedComparison(lhs, rhs = this.getRhsExpression());
            if (e2 != null) {
                return e2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
            e2 = this.tryIndexedComparison(rhs, lhs);
            if (e2 != null) {
                return e2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        return super.optimize(visitor, contextItemType);
    }

    private Expression tryIndexedComparison(Expression lhs, Expression rhs) {
        if (lhs instanceof VariableReference && Cardinality.allowsMany(lhs.getCardinality()) && (rhs.getDependencies() & 0x1E) == 0) {
            GeneralComparisonEE predicate = new GeneralComparisonEE(new ContextItemExpression(), 6, rhs);
            FilterExpression filterExp = new FilterExpression(lhs, predicate);
            return SystemFunction.makeCall("exists", this.getRetainedStaticContext(), filterExp);
        }
        return null;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        GeneralComparisonEE gc = new GeneralComparisonEE(this.getLhsExpression().copy(rebindings), this.operator, this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, gc);
        gc.setRetainedStaticContext(this.getRetainedStaticContext());
        gc.comparer = this.comparer;
        gc.singletonOperator = this.singletonOperator;
        gc.needsRuntimeCheck = this.needsRuntimeCheck;
        gc.comparisonCardinality = this.comparisonCardinality;
        return gc;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        SequenceIterator<?> lhsIter = this.getLhsExpression().iterate(context);
        Object lhsFirst = lhsIter.next();
        if (lhsFirst == null) {
            return false;
        }
        SequenceIterator<?> rhsIter = this.getRhsExpression().iterate(context);
        Object rhsFirst = rhsIter.next();
        if (rhsFirst == null) {
            lhsIter.close();
            return false;
        }
        if (this.compareOneToOne((AtomicValue)lhsFirst, (AtomicValue)rhsFirst, context)) {
            lhsIter.close();
            rhsIter.close();
            return true;
        }
        Object rhsSecond = rhsIter.next();
        if (rhsSecond == null) {
            return this.compareManyToOne(lhsIter, (AtomicValue)rhsFirst, context);
        }
        Object lhsSecond = lhsIter.next();
        if (lhsSecond == null) {
            if (this.compareOneToOne((AtomicValue)lhsFirst, (AtomicValue)rhsSecond, context)) {
                lhsIter.close();
                rhsIter.close();
                return true;
            }
            return this.compareOneToMany((AtomicValue)lhsFirst, rhsIter, context);
        }
        return this.hashJoin(GeneralComparisonEE.prependTwo(lhsFirst, lhsSecond, lhsIter), GeneralComparisonEE.prependTwo(rhsFirst, rhsSecond, rhsIter), context, this.comparer);
    }

    private static SequenceIterator<?> prependTwo(Item first, Item second, SequenceIterator rest) {
        Item[] first2 = new Item[]{first, second};
        return new InsertBefore.InsertIterator(rest, new ArrayIterator(first2), 1);
    }

    private boolean compareOneToOne(AtomicValue lhsValue, AtomicValue rhsValue, XPathContext context) throws XPathException {
        if (this.needsRuntimeCheck && !UType.isGenerallyComparable(lhsValue.getUType(), rhsValue.getUType())) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(lhsValue) + " to " + Type.displayTypeName(rhsValue));
            e2.setErrorCode("XPTY0004");
            e2.setLocation(this.getLocation());
            e2.setIsTypeError(true);
            throw e2;
        }
        return GeneralComparisonEE.compare(lhsValue, this.singletonOperator, rhsValue, this.comparer.provideContext(context), false, context, this.getRetainedStaticContext());
    }

    private boolean compareManyToOne(SequenceIterator lhsIter, AtomicValue rhsValue, XPathContext context) throws XPathException {
        AtomicValue lhsValue;
        while ((lhsValue = (AtomicValue)lhsIter.next()) != null) {
            if (!this.compareOneToOne(lhsValue, rhsValue, context)) continue;
            lhsIter.close();
            return true;
        }
        return false;
    }

    private boolean compareOneToMany(AtomicValue lhsValue, SequenceIterator rhsIter, XPathContext context) throws XPathException {
        AtomicValue rhsValue;
        while ((rhsValue = (AtomicValue)rhsIter.next()) != null) {
            if (!this.compareOneToOne(lhsValue, rhsValue, context)) continue;
            rhsIter.close();
            return true;
        }
        return false;
    }

    private boolean hashJoin(SequenceIterator iter1, SequenceIterator iter2, XPathContext context, AtomicComparer comparer) throws XPathException {
        UType ut2;
        AtomicValue first1 = (AtomicValue)iter1.next();
        if (first1 == null) {
            iter2.close();
            return false;
        }
        AtomicValue first2 = (AtomicValue)iter2.next();
        if (first2 == null) {
            iter1.close();
            return false;
        }
        ConversionRules rules = context.getConfiguration().getConversionRules();
        AtomicComparer boundComparer = comparer.provideContext(context);
        UType ut1 = first1.getItemType().getUType();
        if (UType.NUMERIC.subsumes(ut1)) {
            ut1 = UType.NUMERIC;
        }
        if (UType.NUMERIC.subsumes(ut2 = first2.getItemType().getUType())) {
            ut2 = UType.NUMERIC;
        }
        UType hashTableType = ut1.equals(ut2) ? ut1 : (ut1.equals(UType.UNTYPED_ATOMIC) ? ut2 : ut1);
        StringConverter untypedConverter = hashTableType.equals(UType.NUMERIC) ? rules.getStringToDoubleConverter() : ((BuiltInAtomicType)hashTableType.toItemType()).getStringConverter(rules);
        StringCollator collator = comparer.getCollator();
        int implicitTimezone = context.getImplicitTimezone();
        HashSet<AtomicMatchKey> set1 = new HashSet<AtomicMatchKey>(20);
        HashSet<AtomicMatchKey> set2 = null;
        ArrayList<AtomicValue> strays1 = null;
        ArrayList<AtomicValue> strays2 = null;
        boolean exhausted1 = false;
        boolean exhausted2 = false;
        do {
            String msg;
            ConversionResult result;
            if (!exhausted1) {
                UType t1 = ut1;
                AtomicValue v1 = first1;
                if (t1 == UType.UNTYPED_ATOMIC && hashTableType != UType.UNTYPED_ATOMIC) {
                    t1 = hashTableType;
                    result = untypedConverter.convertString(v1.getStringValueCS());
                    if (result instanceof ValidationFailure) {
                        msg = "Failure converting untypedAtomic value to " + hashTableType + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                        XPathException err = new XPathException(msg, "FORG0001", context);
                        err.setLocation(this.getLocation());
                        throw err;
                    }
                    v1 = (AtomicValue)result;
                }
                if (t1 == hashTableType) {
                    AtomicMatchKey k1 = v1.getXPathComparable(false, collator, implicitTimezone);
                    if (set2 != null && set2.contains(k1)) {
                        iter1.close();
                        iter2.close();
                        return true;
                    }
                    if (!exhausted2) {
                        set1.add(k1);
                    }
                } else if (hashTableType != UType.UNTYPED_ATOMIC && !UType.isPossiblyComparable(t1, hashTableType, false)) {
                    String msg2 = "Cannot compare " + t1 + " to " + hashTableType;
                    XPathException err = new XPathException(msg2, "XPTY0004", context);
                    err.setLocation(this.getLocation());
                    throw err;
                }
                if (ut1 != hashTableType && strays2 != null) {
                    for (AtomicValue stray2 : strays2) {
                        try {
                            if (!GeneralComparisonEE.compare(first1, 50, stray2, boundComparer, false, context, this.getRetainedStaticContext())) continue;
                            return true;
                        }
                        catch (XPathException e) {
                            XPathException err;
                            BuiltInAtomicType it1 = first1.getPrimitiveType();
                            BuiltInAtomicType it2 = stray2.getPrimitiveType();
                            if (it1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                                err = new XPathException("Cannot convert untypedAtomic value to type of second operand (" + it2 + ")");
                                err.setErrorCode("FORG0001");
                            } else if (it2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                                err = new XPathException("Cannot convert untypedAtomic value to type of first operand (" + it1 + ")");
                                err.setErrorCode("FORG0001");
                            } else {
                                err = new XPathException("Cannot compare " + it1 + " to " + it2);
                                err.setErrorCode("XPTY0004");
                            }
                            err.setXPathContext(context);
                            err.setLocation(this.getLocation());
                            throw err;
                        }
                    }
                }
                if (!(ut1 == hashTableType && ut1 != UType.UNTYPED_ATOMIC || exhausted2)) {
                    if (strays1 == null) {
                        strays1 = new ArrayList<AtomicValue>(10);
                    }
                    strays1.add(first1);
                }
                if ((first1 = (AtomicValue)iter1.next()) == null) {
                    exhausted1 = true;
                } else {
                    ut1 = first1.getItemType().getUType();
                    if (UType.NUMERIC.subsumes(ut1)) {
                        ut1 = UType.NUMERIC;
                    }
                }
            }
            if (exhausted2) continue;
            UType t2 = ut2;
            AtomicValue v2 = first2;
            if (t2 == UType.UNTYPED_ATOMIC && hashTableType != UType.UNTYPED_ATOMIC) {
                t2 = hashTableType;
                result = untypedConverter.convertString(v2.getStringValueCS());
                if (result instanceof ValidationFailure) {
                    msg = "Failure converting untypedAtomic value to " + hashTableType + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                    XPathException de = new XPathException(msg, "FORG0001", context);
                    de.setLocation(this.getLocation());
                    throw de;
                }
                v2 = (AtomicValue)result;
            }
            if (t2 == hashTableType) {
                AtomicMatchKey k2 = v2.getXPathComparable(false, collator, implicitTimezone);
                if (set1.contains(k2)) {
                    iter1.close();
                    iter2.close();
                    return true;
                }
                if (!exhausted1) {
                    if (set2 == null) {
                        set2 = new HashSet<AtomicMatchKey>(20);
                    }
                    set2.add(k2);
                }
            }
            if (ut2 != hashTableType && strays1 != null) {
                for (AtomicValue stray1 : strays1) {
                    try {
                        if (!GeneralComparisonEE.compare(first2, 50, stray1, boundComparer, false, context, this.getRetainedStaticContext())) continue;
                        return true;
                    }
                    catch (XPathException e) {
                        XPathException err;
                        BuiltInAtomicType it2 = first2.getPrimitiveType();
                        BuiltInAtomicType it1 = stray1.getPrimitiveType();
                        if (it1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                            err = new XPathException("Cannot convert untypedAtomic value to type of second operand (" + it2 + ")");
                            err.setErrorCode("FORG0001");
                        } else if (it2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                            err = new XPathException("Cannot convert untypedAtomic value to type of first operand (" + it1 + ")");
                            err.setErrorCode("FORG0001");
                        } else {
                            err = new XPathException("Cannot compare " + it1 + " to " + it2);
                            err.setErrorCode("XPTY0004");
                        }
                        err.setXPathContext(context);
                        err.setLocation(this.getLocation());
                        throw err;
                    }
                }
            }
            if (!(ut2 == hashTableType && ut2 != UType.UNTYPED_ATOMIC || exhausted1)) {
                if (strays2 == null) {
                    strays2 = new ArrayList<AtomicValue>(10);
                }
                strays2.add(first2);
            }
            if ((first2 = (AtomicValue)iter2.next()) == null) {
                exhausted2 = true;
                continue;
            }
            ut2 = first2.getItemType().getUType();
            if (!UType.NUMERIC.subsumes(ut2)) continue;
            ut2 = UType.NUMERIC;
        } while (!exhausted1 || !exhausted2);
        return false;
    }

    @Override
    protected GeneralComparison getInverseComparison() {
        GeneralComparisonEE gc = new GeneralComparisonEE(this.getRhsExpression(), Token.inverse(this.operator), this.getLhsExpression());
        gc.setRetainedStaticContext(this.getRetainedStaticContext());
        return gc;
    }

    @Override
    public String tag() {
        return "gcEE";
    }
}

