/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AnalyzeMappingFunction;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;

public class AnalyzeStringCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        CompiledExpression exp;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        AnalyzeString analyzeStr = (AnalyzeString)expression;
        RegularExpression re = analyzeStr.getPatternExpression();
        Expression nonMatching = analyzeStr.getNonMatching();
        Expression matching = analyzeStr.getMatching();
        this.compileRegex(compiler, ga, mi, analyzeStr, re);
        compiler.compileToPrimitive(analyzeStr.getSelect(), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        ga.invokeInstanceMethod(RegularExpression.class, "analyze", CharSequence.class);
        int iterVar = ga.newLocal(RegexIterator.class);
        ga.storeLocal(iterVar);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        int c2Var = mi.allocateLocal(XPathContextMajor.class);
        ga.storeLocal(c2Var);
        mi.pushContextVariableInfo(c2Var, false);
        ga.loadLocal(c2Var);
        AnalyzeStringCompiler.allocateStatic(compiler, analyzeStr);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setOrigin", ContextOriginator.class);
        ga.loadLocal(c2Var);
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        ga.loadLocal(iterVar);
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        ga.loadLocal(c2Var);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentRegexIterator", RegexIterator.class);
        ga.newInstance(ContextMappingIterator.class);
        ga.dup();
        ga.newInstance(AnalyzeMappingFunction.class);
        ga.dup();
        ga.loadLocal(iterVar);
        ga.loadLocal(c2Var);
        if (nonMatching == null) {
            AnalyzeStringCompiler.allocateStatic(compiler, Literal.makeEmptySequence());
        } else {
            exp = compiler.compileToByteCode(nonMatching, "EE_NonMatchingExpr", 2);
            if (exp == null) {
                throw new CannotCompileException(nonMatching);
            }
            AnalyzeStringCompiler.allocateStatic(compiler, exp);
        }
        if (matching == null) {
            AnalyzeStringCompiler.allocateStatic(compiler, Literal.makeEmptySequence());
        } else {
            exp = compiler.compileToByteCode(matching, "EE_MatchingExpr", 2);
            if (exp == null) {
                throw new CannotCompileException(nonMatching);
            }
            AnalyzeStringCompiler.allocateStatic(compiler, exp);
        }
        ga.invokeConstructor(AnalyzeMappingFunction.class, RegexIterator.class, XPathContext.class, Expression.class, Expression.class);
        ga.loadLocal(c2Var);
        ga.invokeConstructor(ContextMappingIterator.class, ContextMappingFunction.class, XPathContext.class);
        mi.popContextVariableInfo();
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        AnalyzeString analyzeStr = (AnalyzeString)expression;
        RegularExpression re = analyzeStr.getPatternExpression();
        this.compileRegex(compiler, ga, mi, analyzeStr, re);
        compiler.compileToPrimitive(analyzeStr.getSelect(), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        ga.invokeInstanceMethod(RegularExpression.class, "analyze", CharSequence.class);
        int iterVar = ga.newLocal(RegexIterator.class);
        ga.storeLocal(iterVar);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        int c2Var = mi.allocateLocal(XPathContextMajor.class);
        ga.storeLocal(c2Var);
        mi.pushContextVariableInfo(c2Var, false);
        ga.loadLocal(c2Var);
        AnalyzeStringCompiler.allocateStatic(compiler, analyzeStr);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setOrigin", ContextOriginator.class);
        ga.loadLocal(c2Var);
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        ga.loadLocal(iterVar);
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        int focusIterVar = ga.newLocal(FocusTrackingIterator.class);
        ga.dup();
        ga.storeLocal(focusIterVar);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        ga.loadLocal(c2Var);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentRegexIterator", RegexIterator.class);
        LabelInfo loop = mi.newLabel("loop");
        LabelInfo breakLoop = mi.newLabel("breakLoop");
        LabelInfo nonMatchingLab = mi.newLabel("nonMatching");
        mi.placeLabel(loop);
        ga.loadLocal(focusIterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.ifNull(breakLoop.label());
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(RegexIterator.class, "isMatching", new Class[0]);
        ga.ifFalse(analyzeStr.getNonMatching() == null ? loop : nonMatchingLab);
        if (analyzeStr.getMatching() != null) {
            compiler.compileToPush(analyzeStr.getMatching());
        }
        ga.goTo(loop);
        mi.placeLabel(nonMatchingLab);
        if (analyzeStr.getNonMatching() != null) {
            compiler.compileToPush(analyzeStr.getNonMatching());
        }
        ga.goTo(loop);
        mi.placeLabel(breakLoop);
        mi.popContextVariableInfo();
    }

    private void compileRegex(CompilerService compiler, Generator ga, GeneratedMethodInfo mi, AnalyzeString analyzeStr, RegularExpression re) throws CannotCompileException {
        if (re == null) {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
            compiler.compileToPrimitive(analyzeStr.getRegex(), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
            compiler.compileToPrimitive(analyzeStr.getFlags(), String.class, OnEmpty.RETURN_EMPTY_STRING);
            ga.push("XP30");
            ga.pushNull();
            ga.invokeInstanceMethod(Configuration.class, "compileRegularExpression", CharSequence.class, String.class, String.class, List.class);
        } else {
            AnalyzeStringCompiler.allocateStatic(compiler, re);
        }
    }
}

