/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import marmot.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    public void test(String form, StringUtils.Mode mode, String expected) {
        String actual = StringUtils.normalize(form, mode);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void identityTest() {
        this.test("\u00c4b1c-LRB-", StringUtils.Mode.none, "\u00c4b1c-LRB-");
    }

    @Test
    public void bracketTest() {
        this.test("\u00c4b1c-LRB-", StringUtils.Mode.bracket, "\u00c4b1c(");
        this.test("-RRB-", StringUtils.Mode.bracket, ")");
        this.test("-RRB-a", StringUtils.Mode.bracket, ")a");
    }

    @Test
    public void lowerTest() {
        this.test("\u00c4b1c-LRB-", StringUtils.Mode.lower, "\u00e4b0c(");
    }

    @Test
    public void umlautTest() {
        this.test("\u00c4b1c-LRB-", StringUtils.Mode.umlaut, "aeb0c(");
    }

    @Test
    public void shapeTest() {
        this.testShape("lower", StringUtils.Shape.Lower);
        this.testShape("Upper", StringUtils.Shape.FirstCap);
        this.testShape("1Upper", StringUtils.Shape.Mixed);
        this.testShape("U1AA", StringUtils.Shape.AllCap);
        this.testShape("123", StringUtils.Shape.NoLetter);
        this.testShape("", StringUtils.Shape.NoLetter);
        this.testShape("a", StringUtils.Shape.Lower);
        this.testShape("A", StringUtils.Shape.AllCap);
        this.testShape("!", StringUtils.Shape.NoLetter);
    }

    private void testShape(String string, StringUtils.Shape shape) {
        Assert.assertEquals((Object)((Object)shape), (Object)((Object)StringUtils.getShape(string)));
    }
}

