/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.Cache;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;

public class CachedFeatureGenerator
implements AdaptiveFeatureGenerator {
    private final AdaptiveFeatureGenerator generator;
    private String[] prevTokens;
    private final Cache<Integer, List<String>> contextsCache;
    private long numberOfCacheHits;
    private long numberOfCacheMisses;

    @Deprecated
    public CachedFeatureGenerator(AdaptiveFeatureGenerator ... generators) {
        this.generator = new AggregatedFeatureGenerator(generators);
        this.contextsCache = new Cache(100);
    }

    public CachedFeatureGenerator(AdaptiveFeatureGenerator generator) {
        this.generator = generator;
        this.contextsCache = new Cache(100);
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        ArrayList<String> cacheFeatures;
        if (tokens == this.prevTokens) {
            cacheFeatures = (ArrayList<String>)this.contextsCache.get(index);
            if (cacheFeatures != null) {
                ++this.numberOfCacheHits;
                features.addAll(cacheFeatures);
                return;
            }
        } else {
            this.contextsCache.clear();
            this.prevTokens = tokens;
        }
        cacheFeatures = new ArrayList<String>();
        ++this.numberOfCacheMisses;
        this.generator.createFeatures(cacheFeatures, tokens, index, previousOutcomes);
        this.contextsCache.put(index, cacheFeatures);
        features.addAll(cacheFeatures);
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        this.generator.updateAdaptiveData(tokens, outcomes);
    }

    @Override
    public void clearAdaptiveData() {
        this.generator.clearAdaptiveData();
    }

    public long getNumberOfCacheHits() {
        return this.numberOfCacheHits;
    }

    public long getNumberOfCacheMisses() {
        return this.numberOfCacheMisses;
    }

    public String toString() {
        return super.toString() + ": hits=" + this.numberOfCacheHits + " misses=" + this.numberOfCacheMisses + " hit%" + (this.numberOfCacheHits > 0L ? (double)this.numberOfCacheHits / (double)(this.numberOfCacheMisses + this.numberOfCacheHits) : 0.0);
    }

    public AdaptiveFeatureGenerator getCachedFeatureGenerator() {
        return this.generator;
    }
}

