/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.toutanova;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import lemming.lemma.Lemmatizer;
import lemming.lemma.LemmatizerGenerator;
import lemming.lemma.toutanova.Decoder;
import lemming.lemma.toutanova.NbestDecoder;
import lemming.lemma.toutanova.Result;
import lemming.lemma.toutanova.ToutanovaInstance;
import lemming.lemma.toutanova.ToutanovaModel;
import lemming.lemma.toutanova.ToutanovaTrainer;
import lemming.lemma.toutanova.ZeroOrderNbestDecoder;

public class ToutanovaLemmatizer
implements Lemmatizer,
LemmatizerGenerator {
    private static final long serialVersionUID = 1L;
    private ToutanovaModel model_;
    private transient Decoder decoder_;
    private transient NbestDecoder nbest_decoder_;
    private ToutanovaTrainer.ToutanovaOptions options_;
    private transient Map<LemmaInstance, String> cache_;

    public ToutanovaLemmatizer(ToutanovaTrainer.ToutanovaOptions options, ToutanovaModel model) {
        this.model_ = model;
        this.options_ = options;
    }

    @Override
    public String lemmatize(LemmaInstance instance) {
        ToutanovaInstance tinstance;
        String lemma;
        if (this.cache_ == null) {
            this.cache_ = new HashMap<LemmaInstance, String>();
        }
        if ((lemma = this.cache_.get(instance)) != null) {
            return lemma;
        }
        if (this.decoder_ == null) {
            this.decoder_ = this.options_.getDecoderInstance();
            this.decoder_.init(this.model_);
        }
        if ((lemma = this.decoder_.decode(tinstance = this.getToutanovaInstance(instance)).getOutput()) == null || lemma.isEmpty()) {
            lemma = "_";
        }
        this.cache_.put(instance, lemma);
        return lemma;
    }

    private ToutanovaInstance getToutanovaInstance(LemmaInstance instance) {
        ToutanovaInstance tinstance = new ToutanovaInstance(instance, null);
        this.model_.addIndexes(tinstance, false);
        return tinstance;
    }

    public ToutanovaModel getModel() {
        return this.model_;
    }

    @Override
    public void addCandidates(LemmaInstance instance, LemmaCandidateSet set) {
        List<Result> results;
        ToutanovaInstance tinstance = this.getToutanovaInstance(instance);
        if (this.nbest_decoder_ == null) {
            this.nbest_decoder_ = new ZeroOrderNbestDecoder(this.options_.getNbestRank());
            this.nbest_decoder_.init(this.model_);
        }
        if ((results = this.nbest_decoder_.decode(tinstance)) == null) {
            return;
        }
        for (Result result : results) {
            set.getCandidate(result.getOutput());
        }
    }

    @Override
    public boolean isOOV(LemmaInstance instance) {
        return this.model_.isOOV(instance);
    }
}

