/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.preprocess;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import marmot.tokenize.preprocess.BufferedReaderWrapper;
import marmot.tokenize.preprocess.InternalReader;
import marmot.tokenize.preprocess.Pair;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class WikiReader
implements Iterator<Pair> {
    private Pair pair_;
    private InternalReader untokenized_;
    private InternalReader tokenized_;
    private boolean expand_;

    public WikiReader(InternalReader untokenized, InternalReader tokenized, boolean expand) {
        this.untokenized_ = untokenized;
        this.tokenized_ = tokenized;
        this.expand_ = expand;
    }

    public WikiReader(String untokenized_file, String tokenized_file, boolean expand) {
        this(WikiReader.openFile(untokenized_file), WikiReader.openFile(tokenized_file), expand);
    }

    public static InternalReader openFile(String file) {
        try {
            return new BufferedReaderWrapper(new BufferedReader(new InputStreamReader((InputStream)new BZip2CompressorInputStream(new FileInputStream(file)), "UTF-8")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        this.readNext();
        return this.pair_ != null;
    }

    protected String fixLine(String line) {
        if (line == null) {
            return line;
        }
        line = line.replace('\u00a0', ' ');
        return line;
    }

    protected String readNonEmptyLine(InternalReader reader) {
        String line = this.fixLine(reader.readLine());
        if (line == null) {
            throw new NoSuchElementException();
        }
        line = line.trim();
        while (line.isEmpty()) {
            line = this.fixLine(reader.readLine());
            if (line == null) {
                throw new NoSuchElementException();
            }
            line = line.trim();
        }
        return line;
    }

    public void readNext() {
        if (this.pair_ != null) {
            return;
        }
        try {
            String tokenized = this.readNonEmptyLine(this.tokenized_);
            String untokenized = this.readNonEmptyLine(this.untokenized_);
            this.pair_ = new Pair(tokenized, untokenized);
            if (this.expand_) {
                this.expandPair();
            }
            if (this.pair_.score > 0.7 && this.pair_.tokenized.length() > 20) {
                throw new RuntimeException(String.format("Alignment error: %s --- %s : %g", this.pair_.tokenized, this.pair_.untokenized, this.pair_.score));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    protected void expandPair() {
        Pair pair;
        boolean expanded = false;
        try {
            this.tokenized_.mark();
            pair = new Pair(this.pair_.tokenized + this.readNonEmptyLine(this.tokenized_), this.pair_.untokenized);
            if (pair.score < this.pair_.score) {
                this.pair_ = pair;
                expanded = true;
            } else {
                this.tokenized_.reset();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.untokenized_.mark();
        pair = new Pair(this.pair_.tokenized, this.pair_.untokenized + this.readNonEmptyLine(this.untokenized_));
        if (pair.score < this.pair_.score) {
            this.pair_ = pair;
            expanded = true;
        } else {
            this.untokenized_.reset();
        }
        if (expanded) {
            this.expandPair();
        }
    }

    @Override
    public Pair next() {
        this.readNext();
        if (this.pair_ == null) {
            throw new NoSuchElementException();
        }
        Pair pair = this.pair_;
        this.pair_ = null;
        return pair;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<Pair> readAll() {
        LinkedList<Pair> pairs = new LinkedList<Pair>();
        while (this.hasNext()) {
            pairs.add(this.next());
        }
        return pairs;
    }
}

