/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ParserExtension;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class SaxonSyntaxExtension
extends ParserExtension {
    @Override
    public Expression parseTypePattern(XPathParser p) throws XPathException {
        ItemType type = p.parseItemType();
        return new ItemTypePattern(type);
    }

    @Override
    public void handleExternalFunctionDeclaration(XQueryParser p, XQueryFunction func) throws XPathException {
        FunctionItem ext;
        QueryModule qenv = (QueryModule)p.getStaticContext();
        SymbolicName.F fName = new SymbolicName.F(func.getFunctionName(), func.getNumberOfParameters());
        if (!qenv.getFunctionLibrary().isAvailable(fName, qenv.getXPathVersion())) {
            p.grumble("External function " + fName + " is not available", "XPST0017");
        }
        if ((ext = qenv.getFunctionLibrary().getFunctionItem(fName, qenv)) == null) {
            p.grumble("External function " + fName + " is not available", "XPST0017");
        } else {
            TypeHierarchy th = qenv.getConfiguration().getTypeHierarchy();
            if (!ext.getFunctionItemType().getResultType().isSameType(func.getResultType(), th)) {
                p.grumble("The declared return type of the external function (" + ext.getFunctionItemType().getResultType() + ") does not match the return type of the actual function (" + func.getResultType());
            }
            for (int i = 0; i < ext.getArity(); ++i) {
                if (ext.getFunctionItemType().getArgumentTypes()[i].isSameType(func.getArgumentTypes()[i], th)) continue;
                p.grumble("The declared type of argument " + i + " of the external function (" + ext.getFunctionItemType().getArgumentTypes()[i] + ") does not match the argument type of the actual function (" + func.getArgumentTypes()[i]);
            }
        }
    }
}

