/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AtomicItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.NumericComparer;
import net.sf.saxon.expr.sort.NumericComparer11;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.Whitespace;

public class GeneralComparisonMinimaxFeed
extends AtomicItemFeed {
    private WatchManager watchManager;
    private AtomicComparer comparer;
    private List<AtomicValue> unstreamedValues;
    private NumericValue minUnstreamedNumeric;
    private NumericValue maxUnstreamedNumeric;
    private int operator;
    private boolean done = false;
    private boolean closed = false;
    private final Expression pullOperand;
    private Predicate<Integer> predicate;

    public GeneralComparisonMinimaxFeed(WatchManager watchManager, Expression expr, int pushedArg, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.watchManager = watchManager;
        GeneralComparison gc = (GeneralComparison)this.getExpression();
        this.comparer = gc.getAtomicComparer();
        this.operator = gc.getSingletonOperator();
        if (pushedArg == 1) {
            this.operator = Token.inverse(this.operator);
        }
        this.pullOperand = pushedArg == 0 ? gc.getRhsExpression() : gc.getLhsExpression();
        this.predicate = GeneralComparisonMinimaxFeed.makeTest(this.operator);
    }

    private static Predicate<Integer> makeTest(int operator) {
        switch (operator) {
            case 53: {
                return i -> i < 0;
            }
            case 55: {
                return i -> i <= 0;
            }
            case 52: {
                return i -> i > 0;
            }
            case 54: {
                return i -> i > 0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.done = false;
    }

    @Override
    public void append(Item item) throws XPathException {
        block18: {
            AtomicValue streamedVal;
            block19: {
                if (this.done) break block18;
                XPathContext context = this.getContext();
                if (this.unstreamedValues == null) {
                    Item it;
                    this.unstreamedValues = new ArrayList<AtomicValue>();
                    SequenceIterator unstreamed = this.pullOperand.iterate(context);
                    while ((it = unstreamed.next()) != null) {
                        NumericValue nv;
                        String str;
                        AtomicValue val = (AtomicValue)it;
                        this.unstreamedValues.add(val);
                        if (val.isUntypedAtomic() && (str = Whitespace.trim(val.getStringValue())).matches("^[-+0-9\\.]*$") && !(nv = NumericValue.parseNumber(str)).isNaN()) {
                            val = nv;
                        }
                        if (!(val instanceof NumericValue)) continue;
                        if (this.minUnstreamedNumeric == null) {
                            this.minUnstreamedNumeric = (NumericValue)val;
                            this.maxUnstreamedNumeric = (NumericValue)val;
                            continue;
                        }
                        NumericComparer comp = NumericComparer11.getInstance();
                        if (comp.compareAtomicValues(val, this.minUnstreamedNumeric) < 0) {
                            this.minUnstreamedNumeric = (NumericValue)val;
                        }
                        if (comp.compareAtomicValues(val, this.maxUnstreamedNumeric) <= 0) continue;
                        this.maxUnstreamedNumeric = (NumericValue)val;
                    }
                    if (this.unstreamedValues.isEmpty()) {
                        this.reportDone(false);
                        return;
                    }
                }
                if ((streamedVal = (AtomicValue)item).isUntypedAtomic() && this.minUnstreamedNumeric != null) {
                    streamedVal = new DoubleValue(StringToDouble11.getInstance().stringToNumber(streamedVal.getUnicodeStringValue()));
                }
                if (!(streamedVal instanceof NumericValue)) break block19;
                NumericComparer comparer = NumericComparer11.getInstance();
                switch (this.operator) {
                    case 55: {
                        if (comparer.compareAtomicValues(streamedVal, this.maxUnstreamedNumeric) <= 0) {
                            this.reportDone(true);
                            return;
                        }
                        break block18;
                    }
                    case 53: {
                        if (comparer.compareAtomicValues(streamedVal, this.maxUnstreamedNumeric) < 0) {
                            this.reportDone(true);
                            return;
                        }
                        break block18;
                    }
                    case 54: {
                        if (comparer.compareAtomicValues(streamedVal, this.minUnstreamedNumeric) >= 0) {
                            this.reportDone(true);
                            return;
                        }
                        break block18;
                    }
                    case 52: {
                        if (comparer.compareAtomicValues(streamedVal, this.minUnstreamedNumeric) > 0) {
                            this.reportDone(true);
                            return;
                        }
                        break block18;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            for (AtomicValue unstreamedVal : this.unstreamedValues) {
                int comp = this.comparer.compareAtomicValues(streamedVal, unstreamedVal);
                if (!this.predicate.test(comp)) continue;
                this.reportDone(true);
                return;
            }
        }
    }

    private void reportDone(boolean result) throws XPathException {
        Outputter out = this.getNextOutputter();
        this.done = true;
        out.append(BooleanValue.get(result));
        if (this.watchManager.allowsEarlyExit()) {
            this.closed = true;
            out.close();
            this.getTerminator().terminate();
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.done) {
            this.getNextOutputter().append(BooleanValue.FALSE);
        }
        if (!this.closed) {
            super.close();
            this.minUnstreamedNumeric = null;
            this.maxUnstreamedNumeric = null;
            this.done = false;
        }
    }
}

