/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.io.Serializable;
import java.util.Arrays;
import marmot.util.Mutable;
import marmot.util.StringUtils;

public class MorphDictionaryOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String filename_;
    private int[] indexes_;
    private StringUtils.Mode norm_;
    private DictionaryType type_;
    private boolean reverse_;
    private int limit_;
    private boolean dense_;

    public static MorphDictionaryOptions parse(String option_string) {
        return MorphDictionaryOptions.parse(option_string, true);
    }

    public static MorphDictionaryOptions parse(String option_string, boolean set_defaults) {
        MorphDictionaryOptions options = new MorphDictionaryOptions();
        if (set_defaults) {
            options.setDefaultOptions();
        }
        Mutable<Integer> index = new Mutable<Integer>(0);
        while (index.get() < option_string.length()) {
            KeyType key = MorphDictionaryOptions.readKey(index, option_string);
            try {
                switch (key) {
                    case filename: {
                        options.filename_ = MorphDictionaryOptions.readStringValue(index, option_string);
                        break;
                    }
                    case type: {
                        options.type_ = MorphDictionaryOptions.readTypeValue(index, option_string);
                        break;
                    }
                    case indexes: {
                        options.indexes_ = MorphDictionaryOptions.readArrayValue(index, option_string);
                        break;
                    }
                    case norm: {
                        options.norm_ = MorphDictionaryOptions.readModeValue(index, option_string);
                        break;
                    }
                    case limit: {
                        options.limit_ = MorphDictionaryOptions.readIntValue(index, option_string);
                        break;
                    }
                    case reverse: {
                        options.reverse_ = MorphDictionaryOptions.readBooleanValue(index, option_string);
                        break;
                    }
                    case dense: {
                        options.dense_ = MorphDictionaryOptions.readBooleanValue(index, option_string);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error: Couldn't parse string: " + option_string + " because of:");
                throw new RuntimeException(e);
            }
        }
        return options;
    }

    private static StringUtils.Mode readModeValue(Mutable<Integer> index, String option_string) {
        String type = MorphDictionaryOptions.readStringValue(index, option_string);
        return StringUtils.Mode.valueOf(type);
    }

    private static int readIntValue(Mutable<Integer> index, String option_string) {
        String type = MorphDictionaryOptions.readStringValue(index, option_string);
        return Integer.parseInt(type);
    }

    private void setDefaultOptions() {
        int[] indexes = new int[]{2, 3};
        this.indexes_ = indexes;
        this.norm_ = StringUtils.Mode.none;
        this.type_ = DictionaryType.hash;
        this.reverse_ = true;
        this.dense_ = false;
        this.limit_ = 10;
    }

    private static boolean readBooleanValue(Mutable<Integer> index, String option_string) {
        String type = MorphDictionaryOptions.readStringValue(index, option_string);
        return Boolean.parseBoolean(type);
    }

    private static int[] readArrayValue(Mutable<Integer> index, String option_string) {
        String[] array = StringUtils.parseArray(option_string, index);
        int[] indexes = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            indexes[i] = Integer.parseInt(array[i]);
        }
        Arrays.sort(indexes);
        if (index.get() < option_string.length() && option_string.charAt(index.get()) == ',') {
            index.set(index.get() + 1);
        }
        return indexes;
    }

    private static DictionaryType readTypeValue(Mutable<Integer> index, String option_string) {
        String type = MorphDictionaryOptions.readStringValue(index, option_string);
        return DictionaryType.valueOf(type);
    }

    private static String readStringValue(Mutable<Integer> index, String option_string) {
        int eq_index = option_string.indexOf(44, (int)index.get());
        if (eq_index == -1) {
            eq_index = option_string.length();
        }
        String value = option_string.substring(index.get(), eq_index);
        index.set(eq_index + 1);
        return value;
    }

    private static KeyType readKey(Mutable<Integer> index, String option_string) {
        int eq_index = option_string.indexOf(61, (int)index.get());
        int co_index = option_string.indexOf(44, (int)index.get());
        if (eq_index == -1 || co_index < eq_index && co_index != -1) {
            return KeyType.filename;
        }
        String key_string = option_string.substring(index.get(), eq_index);
        index.set(eq_index + 1);
        KeyType type = KeyType.valueOf(key_string);
        return type;
    }

    public String getFilename() {
        return this.filename_;
    }

    public StringUtils.Mode getNormalize() {
        return this.norm_;
    }

    public int[] getIndexes() {
        return this.indexes_;
    }

    public DictionaryType getDictType() {
        return this.type_;
    }

    public boolean getReverse() {
        return this.reverse_;
    }

    public int getLimit() {
        return this.limit_;
    }

    public void setIndexes(int[] indexes) {
        this.indexes_ = indexes;
    }

    public boolean getDense() {
        return this.dense_;
    }

    public void setNormalize(StringUtils.Mode mode) {
        this.norm_ = mode;
    }

    public static enum KeyType {
        norm,
        filename,
        indexes,
        type,
        limit,
        reverse,
        dense;

    }

    public static enum DictionaryType {
        hash,
        suffix;

    }
}

