/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SymbolTable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<T, Integer> toIndex;
    private Map<Integer, T> fromIndex;
    private boolean bidirectional_;

    public SymbolTable(boolean bidirectional, int capacity) {
        this.toIndex = new HashMap<T, Integer>(capacity);
        if (bidirectional) {
            this.fromIndex = new HashMap<Integer, T>(capacity);
        }
        this.bidirectional_ = bidirectional;
    }

    public SymbolTable(int capacity) {
        this(false, capacity);
    }

    public SymbolTable() {
        this(false, 10);
    }

    public SymbolTable(SymbolTable<T> symbol_table) {
        this.toIndex = new HashMap<T, Integer>((HashMap)symbol_table.toIndex);
        this.bidirectional_ = symbol_table.bidirectional_;
        if (this.bidirectional_) {
            this.fromIndex = new HashMap<Integer, T>((HashMap)symbol_table.fromIndex);
        }
    }

    public SymbolTable(boolean bidirectional) {
        this(bidirectional, 10);
    }

    public List<Integer> toIndexes(Collection<T> symbols) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(symbols.size());
        for (T symbol : symbols) {
            indexes.add(this.toIndex(symbol));
        }
        return indexes;
    }

    public List<T> toSymbols(Collection<Integer> indexes) {
        ArrayList<T> symbols = new ArrayList<T>(indexes.size());
        for (Integer i : indexes) {
            symbols.add(this.toSymbol(i));
        }
        return symbols;
    }

    public int toIndex(T symbol) {
        return this.toIndex(symbol, false);
    }

    public int toIndex(T symbol, int default_index) {
        return this.toIndex(symbol, default_index, false);
    }

    public int toIndex(T symbol, int default_index, boolean insert) {
        if (symbol == null) {
            throw new NullPointerException();
        }
        Integer index = this.toIndex.get(symbol);
        if (index == null) {
            if (insert) {
                index = this.toIndex.size();
                this.toIndex.put(symbol, index);
                if (this.bidirectional_) {
                    this.fromIndex.put(index, symbol);
                }
            } else {
                return default_index;
            }
        }
        return index;
    }

    public int toIndex(T symbol, boolean insert) {
        int index = this.toIndex(symbol, -1, insert);
        if (index == -1) {
            throw new NoSuchElementException(symbol.toString());
        }
        return index;
    }

    public T toSymbol(Integer index) {
        if (!this.bidirectional_) {
            throw new UnsupportedOperationException("Table is unidirectional!");
        }
        T t2 = this.fromIndex.get(index);
        if (t2 == null) {
            throw new NoSuchElementException();
        }
        return t2;
    }

    public int size() {
        assert (!this.bidirectional_ || this.toIndex.size() == this.fromIndex.size());
        return this.toIndex.size();
    }

    public String toString() {
        return this.toIndex.toString();
    }

    public boolean hasSymbol(T object) {
        return this.toIndex.containsKey(object);
    }

    public Set<Map.Entry<T, Integer>> entrySet() {
        return this.toIndex.entrySet();
    }

    public Collection<T> getSymbols() {
        return this.toIndex.keySet();
    }

    public void setBidirectional(boolean bidirectional) {
        if (this.bidirectional_ != bidirectional) {
            if (!this.bidirectional_) {
                this.fromIndex = new HashMap<Integer, T>((int)((double)this.toIndex.size() * 1.25));
                for (Map.Entry<T, Integer> entry : this.toIndex.entrySet()) {
                    this.fromIndex.put(entry.getValue(), entry.getKey());
                }
                this.bidirectional_ = true;
            } else {
                this.bidirectional_ = false;
                this.fromIndex = null;
            }
        }
    }

    public boolean isBidirectional() {
        return this.bidirectional_;
    }

    public void insert(T symbol) {
        this.toIndex(symbol, true);
    }

    public Set<T> keySet() {
        return this.toIndex.keySet();
    }
}

