/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaDocumentTransformer;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AnyURIValue;

public class SchemaCompiler {
    private final EnterpriseConfiguration config;
    private PreparedSchema preparedSchema;
    private int[] occurrenceLimits;
    private final SchemaURIResolver schemaURIResolver;
    private ErrorReporter errorReporter;
    private HashMap<IdentityConstraintReference, SchemaType> identityConstraintsAwaitingTypeChecking = null;
    private int errorCount = 0;
    private int xsdlVersion = 10;
    private final boolean allowDanglingReferences;
    private final HashMap<String, XSDSchema> documentsAlreadyRead = new HashMap(10);
    private final HashSet<String> documentsBeingRead = new HashSet(10);
    private PipelineConfiguration pipelineConfiguration;
    private SchemaDocumentTransformer chameleonTransformer = null;
    private SchemaDocumentTransformer overrideTransformer = null;
    private final Set<String> componentsReportedMissing = new HashSet<String>();
    private Set<UserComplexType> scheduledForAutomaton = new HashSet<UserComplexType>();
    private Set<UserComplexType[]> scheduledForAutomatonCheck = new HashSet<UserComplexType[]>();

    public SchemaCompiler(EnterpriseConfiguration config) {
        this.config = config;
        this.errorReporter = config.makeErrorReporter();
        this.schemaURIResolver = config.getSchemaURIResolver();
        this.occurrenceLimits = config.getOccurrenceLimits();
        this.allowDanglingReferences = config.getBooleanProperty(Feature.ALLOW_UNRESOLVED_SCHEMA_COMPONENTS);
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void setLanguageVersion(int version) {
        this.xsdlVersion = version;
    }

    public int getLanguageVersion() {
        return this.xsdlVersion;
    }

    public void setPreparedSchema(PreparedSchema schema) {
        this.preparedSchema = schema;
    }

    public PreparedSchema getPreparedSchema() {
        return this.preparedSchema;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = this.config.makeErrorReporter();
        }
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter reporter) {
        this.errorReporter = reporter;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setOccurrenceLimits(int minimum, int maximum) {
        if (minimum < 1 || minimum >= maximum) {
            throw new IllegalArgumentException("Invalid occurrence limits: min<1 or max<min");
        }
        this.occurrenceLimits = new int[]{minimum, maximum};
    }

    public int[] getOccurrenceLimits() {
        return this.occurrenceLimits;
    }

    public void setBeingRead(String systemId) {
        this.documentsBeingRead.add(systemId);
    }

    public boolean isBeingRead(String systemId) {
        return this.documentsBeingRead.contains(systemId);
    }

    public void markAsRead(String systemId, XSDSchema schema) {
        this.documentsBeingRead.remove(systemId);
        this.documentsAlreadyRead.put(systemId + "##" + schema.getTargetNamespace(), schema);
    }

    public boolean isAllowDanglingReferences() {
        return this.allowDanglingReferences;
    }

    public XSDSchema getExistingSchemaDocument(String systemId, NamespaceUri targetNamespace) {
        return this.documentsAlreadyRead.get(systemId + "##" + targetNamespace);
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipelineConfiguration = pipelineConfiguration;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public NamespaceUri readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, NamespaceUri expected) throws SchemaException {
        Source source = SchemaReader.getSource(baseURI, schemaLocation, this, expected);
        if (source == null) {
            throw new SchemaException("No schema could be loaded at location " + schemaLocation);
        }
        SchemaDocument schemadoc = SchemaReader.read(source, this, pipe, null);
        if (schemadoc.isCompiledSchemaDocument()) {
            try {
                this.getConfiguration().importComponents(schemadoc.getDocument().getRootNode().asActiveSource());
                return expected;
            }
            catch (XPathException e) {
                throw new SchemaException(e);
            }
        }
        return this.processSchemaDocument(schemadoc, schemaLocation, expected);
    }

    private NamespaceUri processSchemaDocument(SchemaDocument schemadoc, String schemaLocation, NamespaceUri expected) throws SchemaException {
        if (schemadoc.isCompiledSchemaDocument()) {
            return expected;
        }
        NamespaceUri targetNamespace = schemadoc.getTargetNamespace();
        if (expected != null && !expected.equals(targetNamespace)) {
            SchemaException exception = new SchemaException("Schema " + (schemaLocation == null ? "" : "at location " + schemaLocation + " ") + "has target namespace \"" + targetNamespace + "\" but requested namespace was \"" + expected + '\"');
            if (schemaLocation == null) {
                exception.setErrorCode("XTSE0215");
            }
            throw exception;
        }
        SingleNamespaceSchema ps = schemadoc.getXSDSchema().getSchema();
        this.preparedSchema = ps;
        this.validate(schemadoc);
        this.preparedSchema = null;
        Collection<GlobalParam> globalParams = schemadoc.getXSDSchema().getGlobalParams();
        for (GlobalParam param : globalParams) {
            ps.addGlobalParam(param);
        }
        return targetNamespace;
    }

    private void retainSchemaComponents(PreparedSchema ps) throws SchemaException {
        this.preparedSchema = this.preparedSchema == null ? ps : PreparedSchema.merge(this.preparedSchema, ps);
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, List<String> schemaLocations, NamespaceUri expected) throws SchemaException {
        String[] locations = new String[schemaLocations.size()];
        int loc = 0;
        for (String schemaLocation : schemaLocations) {
            locations[loc++] = schemaLocation;
        }
        Source[] sources = SchemaReader.getSources(baseURI, locations, this, expected);
        if (sources.length == 0) {
            return;
        }
        boolean success = false;
        SchemaException lastException = null;
        PreparedSchema mergedSchema = null;
        for (int i = 0; i < sources.length; ++i) {
            try {
                Source source = sources[i];
                if (source == null) {
                    throw new SchemaException("Unable to load schema at " + schemaLocations.get(i));
                }
                SchemaDocument schemadoc = SchemaReader.read(source, this, pipe, null);
                if (schemadoc.isCompiledSchemaDocument()) {
                    throw new SchemaException("Only source schema documents (not SCM compiled schemas) are accepted here");
                }
                success = true;
                SingleNamespaceSchema ps = schemadoc.getXSDSchema().getSchema();
                mergedSchema = mergedSchema == null ? ps : PreparedSchema.merge(mergedSchema, ps);
                NamespaceUri targetNamespace = schemadoc.getTargetNamespace();
                if (expected == null || expected.equals(targetNamespace)) continue;
                throw new SchemaException("Schema at " + locations[i] + " has target namespace \"" + targetNamespace + "\" but requested namespace was \"" + expected + '\"');
            }
            catch (SchemaException e) {
                if (e.getException() instanceof IOException) {
                    XmlProcessingException ee = new XmlProcessingException(e);
                    ee.setWarning(true);
                    pipe.getErrorReporter().report(ee);
                    continue;
                }
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (!success) {
            throw new SchemaException("No valid schema was found");
        }
        this.preparedSchema = mergedSchema;
        mergedSchema.validate(this);
        this.makeAllAutomata();
        this.checkAllAutomata();
        this.preparedSchema = null;
    }

    public NamespaceUri readInlineSchema(NodeInfo root, NamespaceUri expected, ErrorReporter errorReporter) throws SchemaException {
        ErrorReporter listener = errorReporter == null ? this.getErrorReporter() : errorReporter;
        this.setErrorReporter(listener);
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setErrorReporter(listener);
        pipe.setHostLanguage(HostLanguage.XML_SCHEMA);
        SchemaDocument schemadoc = SchemaReader.read(root.asActiveSource(), this, pipe, null);
        return this.processSchemaDocument(schemadoc, null, expected);
    }

    public void compile() throws SchemaException {
        boolean valid = this.preparedSchema.validate(this);
        if (!valid) {
            throw new SchemaException("The schema is invalid");
        }
    }

    public PreparedSchema validate(SchemaDocument doc) throws SchemaException {
        if (doc.isCompiledSchemaDocument()) {
            throw new SchemaException("Only source schema documents (not SCM compiled schemas) are accepted here");
        }
        XSDSchema schemaRoot = doc.getXSDSchema();
        this.preparedSchema = schemaRoot.getSchema();
        int errors = schemaRoot.getErrorCount();
        if (errors > 0) {
            String msg = errors == 1 ? "One error was" : errors + " errors were";
            throw new SchemaException(msg + " found while processing the schema");
        }
        for (GlobalParam param : schemaRoot.getGlobalParams()) {
            this.preparedSchema.addGlobalParam(param);
        }
        this.compile();
        this.makeAllAutomata();
        this.checkAllAutomata();
        PreparedSchema ps = this.preparedSchema;
        this.preparedSchema = null;
        return ps;
    }

    public boolean reportMissingComponent(String componentType, StructuredQName componentName) {
        String key = componentType + " " + componentName.getEQName();
        return this.componentsReportedMissing.add(key);
    }

    public void error(String message, Location locator) {
        ++this.errorCount;
        this.getErrorReporter().report(new XmlProcessingIncident(message, "SXXP0006", locator));
    }

    public void warning(String message, String errorCode, Location locator) {
        if (locator.getSystemId() != null && locator.getSystemId().endsWith("override.xsl")) {
            locator = new Loc("schema_document_resulting_from_override_processing", -1, -1);
        }
        XmlProcessingIncident exception = new XmlProcessingIncident(message, errorCode, locator).asWarning();
        this.getErrorReporter().report(exception);
    }

    public void addPendingTypeCheck(IdentityConstraintReference constraint, SchemaType contextItemType) {
        if (this.identityConstraintsAwaitingTypeChecking == null) {
            this.identityConstraintsAwaitingTypeChecking = new HashMap(20);
        }
        this.identityConstraintsAwaitingTypeChecking.put(constraint, contextItemType);
    }

    public void typeCheckIdentityConstraints() throws SchemaException {
        try {
            if (this.identityConstraintsAwaitingTypeChecking != null) {
                for (Map.Entry<IdentityConstraintReference, SchemaType> e : this.identityConstraintsAwaitingTypeChecking.entrySet()) {
                    IdentityConstraint constraint = e.getKey().getTarget();
                    SchemaType contextItemType = e.getValue();
                    constraint.typeCheck(this, contextItemType);
                }
                this.identityConstraintsAwaitingTypeChecking = null;
            }
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public SchemaDocument doChameleonTransformation(NodeInfo input, SchemaElement referrer) throws SchemaException {
        if (this.chameleonTransformer == null) {
            this.chameleonTransformer = new SchemaDocumentTransformer(this.config, "chameleon.xsl");
        }
        HashMap<StructuredQName, AnyURIValue> params = new HashMap<StructuredQName, AnyURIValue>();
        params.put(NamespaceUri.NULL.qName("newTargetNamespace"), new AnyURIValue(referrer.getXSDSchema().getTargetNamespace().toUnicodeString()));
        GlobalParameterSet parameterSet = new GlobalParameterSet();
        parameterSet.put(NamespaceUri.NULL.qName("newTargetNamespace"), new AnyURIValue(referrer.getXSDSchema().getTargetNamespace().toUnicodeString()));
        TreeInfo doc = this.chameleonTransformer.transform(this, this.pipelineConfiguration, referrer, input, parameterSet);
        return new SchemaDocument(doc);
    }

    public SchemaDocument doOverrideTransformation(NodeInfo input, SchemaElement referrer) throws SchemaException {
        if (this.overrideTransformer == null) {
            this.overrideTransformer = new SchemaDocumentTransformer(this.config, "override.xsl");
        }
        GlobalParameterSet params = new GlobalParameterSet();
        params.put(NamespaceUri.NULL.qName("overrideElement"), referrer);
        TreeInfo doc = this.overrideTransformer.transform(this, this.pipelineConfiguration, referrer, input, params);
        return new SchemaDocument(doc);
    }

    public void scheduleAutomaton(UserComplexType type) {
        this.scheduledForAutomaton.add(type);
    }

    public void scheduleAutomatonCheck(UserComplexType base, UserComplexType sub) {
        this.scheduledForAutomatonCheck.add(new UserComplexType[]{base, sub});
    }

    public void makeAllAutomata() throws SchemaException {
        for (UserComplexType type : this.scheduledForAutomaton) {
            type.makeAutomaton(this);
        }
    }

    public void checkAllAutomata() throws SchemaException {
        for (UserComplexType[] pair : this.scheduledForAutomatonCheck) {
            UserComplexType sub = pair[1];
            UserComplexType base = pair[0];
            String subsumeError = FiniteStateMachine.subsumesMachine(base.getFiniteStateMachine(), sub.getFiniteStateMachine(), this);
            if (subsumeError == null) continue;
            String message = subsumeError.startsWith("?") ? "Saxon is unable to determine whether or not the content model of the complex type " + sub.getDescription() + " is a valid restriction of the content model of the type " + base.getDescription() + ". " + subsumeError.substring(1) : "The content model of the complex type " + sub.getDescription() + " is not a valid restriction of the content model of the type " + base.getDescription() + ". " + subsumeError;
            this.error(message, sub);
            throw new SchemaException(message);
        }
    }
}

