/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.ReplaceValueAction;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.UpdateElaborator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class ReplaceValueExpression
extends BasicUpdatingExpression {
    private final Operand targetOp;
    private final Operand replacementOp;

    public ReplaceValueExpression(Expression target, Expression replacement) {
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.replacementOp = new Operand(this, replacement, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getTargetExp() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExp(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    public Expression getReplacementExp() {
        return this.replacementOp.getChildExpression();
    }

    public void setReplacementExp(Expression replacement) {
        this.replacementOp.setChildExpression(replacement);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.targetOp, this.replacementOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression result1 = this.getReplacementExp();
        this.setReplacementExp(XQueryParser.stringify(result1, true, visitor.getStaticContext()));
        Expression result = this.getReplacementExp();
        this.setReplacementExp(new ValueOf(result, false, true));
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        Supplier<RoleDiagnostic> roleSupplier0 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "replace", 0);
            role0.setErrorCode("XUDY0027");
            return role0;
        };
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.NON_EMPTY_SEQUENCE, roleSupplier0, visitor));
        Supplier<RoleDiagnostic> roleSupplier1 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "replace", 0);
            role0.setErrorCode("XUTY0008");
            return role0;
        };
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.OPTIONAL_NODE, roleSupplier1, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression result = this.getReplacementExp();
        ReplaceValueExpression exp = new ReplaceValueExpression(this.getTargetExp().copy(rebindings), result.copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("replaceValue", this);
        this.getTargetExp().export(out);
        Expression result = this.getReplacementExp();
        result.export(out);
        out.endElement();
    }

    @Override
    public String getExpressionName() {
        return "replaceValue";
    }

    @Override
    public Elaborator getElaborator() {
        return new ReplaceValueExpressionElaborator();
    }

    private static class ReplaceValueExpressionElaborator
    extends UpdateElaborator {
        private ReplaceValueExpressionElaborator() {
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            ReplaceValueExpression expr = (ReplaceValueExpression)this.getExpression();
            ItemEvaluator targetEval = expr.getTargetExp().makeElaborator().elaborateForItem();
            ItemEvaluator replacementEval = expr.getReplacementExp().makeElaborator().elaborateForItem();
            return (context, pul) -> {
                Item newText = replacementEval.eval(context);
                String newString = newText == null ? "" : newText.getStringValue();
                NodeInfo targetNode = (NodeInfo)targetEval.eval(context);
                if (!targetNode.getTreeInfo().isMutable()) {
                    throw new XPathException("Target of replace value expression is not updatable", "SXUP0081");
                }
                XPathException err = null;
                switch (targetNode.getNodeKind()) {
                    case 8: {
                        if (newString.contains("--")) {
                            err = new XPathException("Replacement comment value cannot contain two adjacent hyphens", "XQDY0072");
                            break;
                        }
                        if (!newString.endsWith("-")) break;
                        err = new XPathException("Replacement comment value cannot end with a hyphen", "XQDY0072");
                        break;
                    }
                    case 7: {
                        if (!newString.contains("?>")) break;
                        err = new XPathException("Replacement processing instruction value cannot contain '?>'", "XQDY0026");
                        break;
                    }
                    case 9: {
                        err = new XPathException("Cannot replace the value of a document node", "XUTY0008");
                        break;
                    }
                    case 13: {
                        err = new XPathException("Cannot replace the value of a namespace node", "XUTY0008");
                        break;
                    }
                }
                if (err != null) {
                    throw err.withLocation(expr.getLocation()).withXPathContext(context);
                }
                if (!(targetNode instanceof MutableNodeInfo)) {
                    throw new XPathException("Target node of replace value expression is not updatable", "SXUP0081").withLocation(expr.getLocation());
                }
                try {
                    ReplaceValueAction action = new ReplaceValueAction(StringView.tidy(newString), (MutableNodeInfo)targetNode);
                    action.setOriginator(expr);
                    ((PendingUpdateListImpl)pul).add(action);
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                }
            };
        }
    }
}

