/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Stack;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class PathMaintainer
extends ProxyReceiver {
    private final Stack<AbsolutePath.PathElement> path = new Stack();
    private final Stack<HashMap<NodeName, Integer>> siblingCounters = new Stack();

    public PathMaintainer(Receiver next) {
        super(next);
        this.siblingCounters.push(new HashMap());
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        HashMap<NodeName, Integer> counters = this.siblingCounters.peek();
        int preceding = counters.getOrDefault(elemName, 0);
        int index = preceding + 1;
        counters.put(elemName, index);
        this.path.push(new AbsolutePath.PathElement(1, elemName, index));
        this.siblingCounters.push(new HashMap());
        this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        this.siblingCounters.pop();
        this.path.pop();
    }

    public AbsolutePath getAbsolutePath() {
        return new AbsolutePath(this.path);
    }
}

