/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.xtupdate;

import com.saxonica.ee.update.CopyModifyExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;

public class SaxonUpdate
extends ExtensionInstruction {
    private Expression select;

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected void prepareAttributes() {
        String selectAtt = null;
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            if (f.equals("select")) {
                selectAtt = value;
                this.select = this.makeExpression(selectAtt, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (selectAtt == null) {
            this.select = new ContextItemExpression();
            this.select.setLocation(this.allocateLocation());
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(2, "saxon:modify", this.getPackageData().getLocalLicenseId());
        this.select = this.typeCheck("select", this.select);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression action = this.compileSequenceConstructor(exec, decl, true);
        if (action == null) {
            action = Literal.makeEmptySequence();
        }
        CopyModifyExpression exp = new CopyModifyExpression(action, new ContextItemExpression(), 4);
        CopyOf copy = new CopyOf(this.select, true, 4, null, false);
        copy.setCopyForUpdate(true);
        ForEach forEach = new ForEach(copy, exp);
        return forEach;
    }

    public static void checkContainment(StyleElement child) throws XPathException {
        NodeInfo s = child;
        do {
            if (!((s = s.getParent()) instanceof SaxonUpdate)) continue;
            return;
        } while (s instanceof XSLIf || s instanceof XSLChoose || s instanceof XSLWhen || s instanceof XSLOtherwise || s instanceof XSLForEach);
        child.compileError("The " + child.getDisplayName() + " instruction must be contained within saxon:update; only xsl:if, xsl:choose, and xsl:for-each may intervene");
    }
}

