/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.instruct;

import com.saxonica.xsltextn.pedigree.Pedigree;
import com.saxonica.xsltextn.pedigree.PedigreeArrayItem;
import com.saxonica.xsltextn.pedigree.PedigreeMapItem;
import com.saxonica.xsltextn.pedigree.PedigreeValue;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class DeepUpdate
extends Instruction {
    private final Operand rootOp;
    private final Operand selectOp;
    private final Operand actionOp;

    public DeepUpdate(Expression root, Expression select, Expression action) {
        this.rootOp = new Operand(this, root, OperandRole.INSPECT);
        this.selectOp = new Operand(this, select, OperandRole.FOCUS_CONTROLLED_ACTION);
        this.actionOp = new Operand(this, action, OperandRole.FOCUS_CONTROLLED_ACTION);
    }

    public Expression getRootExpression() {
        return this.rootOp.getChildExpression();
    }

    public Expression getSelectExpression() {
        return this.selectOp.getChildExpression();
    }

    public Expression getActionExpression() {
        return this.actionOp.getChildExpression();
    }

    public void setRootExpression(Expression expr) {
        this.rootOp.setChildExpression(expr);
    }

    public void setSelectExpression(Expression expr) {
        this.selectOp.setChildExpression(expr);
    }

    public void setActionExpression(Expression expr) {
        this.actionOp.setChildExpression(expr);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.rootOp, this.selectOp, this.actionOp);
    }

    @Override
    public int getInstructionNameCode() {
        return 259;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.rootOp.typeCheck(visitor, contextInfo);
        ContextItemStaticInfo ciso2 = new ContextItemStaticInfo(this.getRootExpression().getItemType(), false);
        this.selectOp.typeCheck(visitor, ciso2);
        ContextItemStaticInfo ciso3 = new ContextItemStaticInfo(this.getSelectExpression().getItemType(), false);
        this.actionOp.typeCheck(visitor, ciso3);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(4, "deep-update/root", 0);
        SequenceType required = SequenceType.FUNCTION_ITEM_SEQUENCE;
        this.setRootExpression(tc.staticTypeCheck(this.getRootExpression(), required, role, visitor));
        role = () -> new RoleDiagnostic(4, "deep-update/select", 0);
        this.setSelectExpression(tc.staticTypeCheck(this.getSelectExpression(), required, role, visitor));
        role = () -> new RoleDiagnostic(4, "deep-update/action", 0);
        this.setActionExpression(tc.staticTypeCheck(this.getActionExpression(), SequenceType.ANY_SEQUENCE, role, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        DeepUpdate exp = new DeepUpdate(this.getRootExpression().copy(rebindings), this.getSelectExpression().copy(rebindings), this.getActionExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public ItemType getItemType() {
        return this.getRootExpression().getItemType();
    }

    private static Item makeRootWithPedigree(Item root) {
        if (root instanceof MapItem) {
            return new PedigreeMapItem((MapItem)root);
        }
        if (root instanceof ArrayItem) {
            return new PedigreeArrayItem((ArrayItem)root);
        }
        assert (false);
        return null;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("deepUpdate", this);
        out.setChildRole("root");
        this.getRootExpression().export(out);
        out.setChildRole("select");
        this.getSelectExpression().export(out);
        out.setChildRole("action");
        this.getActionExpression().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new DeepUpdateElaborator();
    }

    private static class DeepUpdateElaborator
    extends PushElaborator {
        private DeepUpdateElaborator() {
        }

        @Override
        public PushEvaluator elaborateForPush() {
            DeepUpdate expr = (DeepUpdate)this.getExpression();
            PullEvaluator rootPuller = expr.getRootExpression().makeElaborator().elaborateForPull();
            PullEvaluator selectPuller = expr.getSelectExpression().makeElaborator().elaborateForPull();
            PullEvaluator actionPuller = expr.getActionExpression().makeElaborator().elaborateForPull();
            return (output, context) -> {
                Item root;
                SequenceIterator rootIterator = rootPuller.iterate(context);
                MappingIterator mappedRootIterator = MappingIterator.map(rootIterator, item -> SingletonIterator.makeIterator(DeepUpdate.makeRootWithPedigree(item)));
                XPathContextMinor c2 = context.newMinorContext();
                FocusIterator trackingIterator = c2.trackFocus(mappedRootIterator);
                while ((root = trackingIterator.next()) != null) {
                    Item selected;
                    Item root1 = root;
                    IdentityHashMap<Item, Item> substitutions = new IdentityHashMap<Item, Item>();
                    XPathContextMinor c3 = c2.newMinorContext();
                    FocusIterator selectIterator = c3.trackFocus(selectPuller.iterate(c2));
                    while ((selected = selectIterator.next()) != null) {
                        GroundedValue actionVal;
                        if (!(selected instanceof PedigreeValue)) {
                            if (selected instanceof MapItem) {
                                throw new XPathException("saxon:deep-update: selected item is a map with no pedigree");
                            }
                            if (selected instanceof ArrayItem) {
                                throw new XPathException("saxon:deep-update: selected item is an array with no pedigree");
                            }
                            throw new XPathException("saxon:deep-update: selected value " + Err.depict(selected) + " is an instance of " + SequenceTool.getItemType(selected, c2.getConfiguration().getTypeHierarchy()) + " (expected a map/array with pedigree)");
                        }
                        SequenceIterator actionIter = actionPuller.iterate(c3);
                        try {
                            actionVal = SequenceTool.toGroundedValue(actionIter);
                        }
                        catch (UncheckedXPathException e) {
                            throw e.getXPathException();
                        }
                        Pedigree pedigree = ((PedigreeValue)((Object)selected)).getPedigree();
                        PedigreeValue parent = pedigree.getContainer();
                        GroundedValue val = actionVal;
                        while (parent != null) {
                            Item latestParent = (Item)((Object)parent);
                            if (substitutions.containsKey((Item)((Object)parent))) {
                                latestParent = (Item)substitutions.get((Item)((Object)parent));
                            }
                            if (latestParent instanceof ArrayItem) {
                                val = ((ArrayItem)latestParent).put(pedigree.getIndex(), val);
                            } else if (latestParent instanceof MapItem) {
                                val = ((MapItem)latestParent).addEntry(pedigree.getKey(), val);
                            } else assert (false);
                            substitutions.put((Item)((Object)parent), (Item)val);
                            substitutions.put(latestParent, (Item)val);
                            pedigree = parent.getPedigree();
                            parent = pedigree.getContainer();
                        }
                        root1 = (Item)val;
                    }
                    Item replacedRoot = root1;
                    output.append(replacedRoot);
                }
                return null;
            };
        }
    }
}

