/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.option.jdom2.JDOM2DocumentWrapper;
import net.sf.saxon.option.jdom2.JDOM2Writer;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;

public class JDOM2ObjectModel
extends TreeModel
implements ExternalObjectModel {
    private static final JDOM2ObjectModel THE_INSTANCE = new JDOM2ObjectModel();

    public static JDOM2ObjectModel getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getDocumentClassName() {
        return "org.jdom2.Document";
    }

    @Override
    public String getIdentifyingURI() {
        return "http://jdom.org/jaxp/xpath/jdom";
    }

    @Override
    public Builder makeBuilder(PipelineConfiguration pipe) {
        return new JDOM2Writer(pipe);
    }

    @Override
    public int getSymbolicValue() {
        return 4;
    }

    @Override
    public String getName() {
        return "JDOM2";
    }

    private static boolean isRecognizedNode(Object object) {
        return object instanceof Document || object instanceof Element || object instanceof Attribute || object instanceof Text || object instanceof Comment || object instanceof ProcessingInstruction || object instanceof Namespace;
    }

    @Override
    public PJConverter getPJConverter(Class<?> targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(Sequence value, Class<?> targetClass, XPathContext context) {
                    return JDOM2ObjectModel.this.convertXPathValueToObject(value, targetClass);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class sourceClass, Configuration config) {
        if (this.isRecognizedNodeClass(sourceClass)) {
            return new JPConverter(){

                @Override
                public GroundedValue convert(Object object, XPathContext context) {
                    return JDOM2ObjectModel.this.convertObjectToXPathValue(object, context.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    private boolean isRecognizedNodeClass(Class nodeClass) {
        return Document.class.isAssignableFrom(nodeClass) || Element.class.isAssignableFrom(nodeClass) || Attribute.class.isAssignableFrom(nodeClass) || Text.class.isAssignableFrom(nodeClass) || CDATA.class.isAssignableFrom(nodeClass) || Comment.class.isAssignableFrom(nodeClass) || ProcessingInstruction.class.isAssignableFrom(nodeClass) || Namespace.class.isAssignableFrom(nodeClass);
    }

    @Override
    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    private GroundedValue convertObjectToXPathValue(Object object, Configuration config) {
        if (JDOM2ObjectModel.isRecognizedNode(object)) {
            if (object instanceof Document) {
                return this.wrapDocument(object, config).getRootNode();
            }
            Document root = JDOM2ObjectModel.getDocumentRoot(object);
            TreeInfo docInfo = this.wrapDocument(root, config);
            return this.wrapNode(docInfo, object);
        }
        return null;
    }

    private Object convertXPathValueToObject(Sequence value, Class<?> target) {
        Object u;
        if (value instanceof VirtualNode && target.isAssignableFrom((u = ((VirtualNode)value).getRealNode()).getClass())) {
            return u;
        }
        return null;
    }

    public TreeInfo wrapDocument(Object node, Configuration config) {
        Document documentNode = JDOM2ObjectModel.getDocumentRoot(node);
        return new JDOM2DocumentWrapper(documentNode, config);
    }

    public NodeInfo wrapNode(TreeInfo document, Object node) {
        return ((JDOM2DocumentWrapper)document).wrap(node);
    }

    private static Document getDocumentRoot(Object node) {
        while (!(node instanceof Document)) {
            if (node instanceof Element) {
                if (((Element)node).isRootElement()) {
                    return ((Element)node).getDocument();
                }
                node = ((Element)node).getParent();
                continue;
            }
            if (node instanceof Text) {
                node = ((Text)node).getParent();
                continue;
            }
            if (node instanceof Comment) {
                node = ((Comment)node).getParent();
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                node = ((ProcessingInstruction)node).getParent();
                continue;
            }
            if (node instanceof Attribute) {
                node = ((Attribute)node).getParent();
                continue;
            }
            if (node instanceof Namespace) {
                throw new UnsupportedOperationException("Cannot find parent of JDOM namespace node");
            }
            throw new IllegalStateException("Unknown JDOM node type " + node.getClass());
        }
        return (Document)node;
    }
}

