/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;

public class TextPrependedTokenStream
extends TokenStream {
    private final CharTermAttribute charTermAttr = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAttr = this.addAttribute(PositionIncrementAttribute.class);
    private final CharacterUtils charUtils = CharacterUtils.getInstance();
    private Boolean init = true;
    private String verbatim;
    private int skippedPositions;
    private StandardTokenizerImpl scanner;
    private final int maxTokenLength = 0x100000;

    public TextPrependedTokenStream(String text) {
        this.verbatim = text;
        this.scanner = null;
    }

    public void doNotPrepend() {
        this.init = false;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        if (this.init.booleanValue()) {
            this.posIncrAttr.setPositionIncrement(255);
            this.charTermAttr.append(this.verbatim);
            this.init = false;
            return true;
        }
        if (this.scanner == null) {
            this.scanner = new StandardTokenizerImpl(new StringReader(this.verbatim));
        }
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= 0x100000) {
                this.posIncrAttr.setPositionIncrement(this.skippedPositions + 1);
                this.scanner.getText(this.charTermAttr);
                this.charUtils.toLowerCase(this.charTermAttr.buffer(), 0, this.charTermAttr.length());
                return true;
            }
            ++this.skippedPositions;
        }
        return false;
    }
}

