/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.functions.NodeName_1;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.QNameValue;

public class NodeNameFnCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo nodeNameReturn = methodInfo.newLabel("nodeNameReturn");
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        NodeName_1 fn = (NodeName_1)fnc.getTargetFunction();
        ItemType argType = fnc.getArg(0).getItemType();
        boolean alwaysNamed = th.isSubType(argType, NodeKindTest.ELEMENT) || th.isSubType(argType, NodeKindTest.ATTRIBUTE);
        compiler.compileToItem(fnc.getArg(0));
        if (Cardinality.allowsZero(fnc.getArg(0).getCardinality())) {
            LabelInfo nodeNotNull = methodInfo.newLabel("nodeNotNull");
            ga.dup();
            ga.ifNonNull(nodeNotNull.label());
            ga.goTo(nodeNameReturn);
            methodInfo.placeLabel(nodeNotNull);
        }
        ga.checkClass(NodeInfo.class);
        int nodeVar = ga.newLocal(NodeInfo.class);
        ga.storeLocal(nodeVar);
        int lnameVar = ga.newLocal(String.class);
        ga.loadLocal(nodeVar);
        ga.invokeInstanceMethod(NodeInfo.class, "getLocalPart", new Class[0]);
        ga.storeLocal(lnameVar);
        if (!alwaysNamed) {
            LabelInfo nodeIsNamed = methodInfo.newLabel("nodeIsNamed");
            ga.loadLocal(lnameVar);
            ga.invokeInstanceMethod(String.class, "isEmpty", new Class[0]);
            ga.ifFalse(nodeIsNamed);
            ga.pushNull();
            ga.goTo(nodeNameReturn);
            methodInfo.placeLabel(nodeIsNamed);
        }
        ga.newInstance(Type.getType(QNameValue.class));
        ga.dup();
        ga.loadLocal(nodeVar);
        ga.invokeInstanceMethod(NodeInfo.class, "getPrefix", new Class[0]);
        ga.loadLocal(nodeVar);
        ga.invokeInstanceMethod(NodeInfo.class, "getURI", new Class[0]);
        ga.loadLocal(lnameVar);
        NodeNameFnCompiler.allocateStatic(compiler, BuiltInAtomicType.QNAME);
        ga.invokeConstructor(QNameValue.class, String.class, String.class, String.class, AtomicType.class);
        methodInfo.placeLabel(nodeNameReturn);
        methodInfo.releaseLocal(nodeVar);
        methodInfo.releaseLocal(lnameVar);
    }
}

