/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.ComponentInversion;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingSequenceWriter;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenOrCloseFeed;
import com.saxonica.ee.stream.feed.ShallowCopyEventFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.TemplateRuleEE;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleSetWithWarnings;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.util.Navigator;

public class ApplyTemplatesAction
extends ItemFeed {
    private Component.M mode;
    private XPathContextMajor localContext;
    private WatchManager watchManager;
    private ParameterSet actualParams = null;
    private ParameterSet tunnelParams = null;
    boolean tracing;
    private static AncestorQualifiedPattern CHILD_NODE_SELECTION = new AncestorQualifiedPattern(new NodeTestPattern(AnyChildNodeTest.getInstance()), AnchorPattern.getInstance(), 9);

    public ApplyTemplatesAction(Expression expression, Feed result, XPathContext context) {
        super(expression, result, context);
        this.tracing = context.getController().isTracing();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        ITemplateCall exp = (ITemplateCall)((Object)this.getExpression());
        if (exp != null) {
            this.computeActualParams(exp.getActualParams());
            this.computeTunnelParams(exp.getTunnelParams());
        }
        this.localContext = this.getContext().newContext();
        ManualIterator iter = new ManualIterator();
        this.localContext.setCurrentIterator(iter);
        this.localContext.setCurrentComponent(this.mode);
        this.localContext.setLocalParameters(this.actualParams);
        this.localContext.setTunnelParameters(this.tunnelParams);
        this.localContext.setCurrentMode(this.mode);
        this.localContext.setCurrentComponent(this.mode);
        this.localContext.setCurrentGroupIterator(null);
        this.localContext.setCurrentMergeGroupIterator(null);
    }

    public void computeActualParams(WithParam[] params) throws XPathException {
        this.actualParams = Instruction.assembleParams(this.getContext(), params);
    }

    public void computeTunnelParams(WithParam[] params) throws XPathException {
        this.tunnelParams = Instruction.assembleTunnelParams(this.getContext(), params);
    }

    public void setActualParams(ParameterSet params) throws XPathException {
        this.actualParams = params;
    }

    public void setTunnelParams(ParameterSet params) throws XPathException {
        this.tunnelParams = params;
    }

    protected XPathContext getLocalContext() {
        return this.localContext;
    }

    public void setMode(Component.M mode) {
        this.mode = mode;
    }

    public Component getMode() {
        return this.mode;
    }

    public void setWatchManager(WatchManager watchManager) {
        this.watchManager = watchManager;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.tracing) {
            TraceListener listener = this.getContext().getController().getTraceListener();
            listener.startCurrentItem(node);
        }
        ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        ComponentInversion inversion = null;
        Rule rule = this.getRule(node);
        if (rule == null) {
            BuiltInRuleSet builtInRuleSet = this.mode.getActor().getBuiltInRuleSet();
            if (builtInRuleSet instanceof RuleSetWithWarnings) {
                ((RuleSetWithWarnings)builtInRuleSet).outputWarning(node, this.localContext);
            }
            int[] action = builtInRuleSet.getActionForParentNodes(node.getNodeKind());
            switch (action[0]) {
                case 1: {
                    NoOpenOrCloseFeed out = new NoOpenOrCloseFeed(this.getResult(), this.getContext());
                    Trigger copyWatch = CopyOfFeed.getWatch(out, AnchorPattern.getInstance(), this.watchManager, this.getContext());
                    this.watchManager.addWatch(copyWatch, true);
                    return null;
                }
                case 4: {
                    XPathException err = new XPathException("No user-defined template rule matches the node " + Navigator.getPath(node), "XTDE0555");
                    err.setLocator(locationId);
                    throw err;
                }
                case 3: {
                    return null;
                }
                case 5: {
                    XPathContextMajor context = this.localContext;
                    Receiver receiver = this.getResult().getReceiver();
                    ShallowCopyEventFeed copyFeed = new ShallowCopyEventFeed(this.mode.getActor(), (Feed)new DecomposingFeed(receiver), (XPathContext)context);
                    ApplyTemplatesAction actor = new ApplyTemplatesAction(null, copyFeed, context);
                    actor.setMode(this.mode);
                    actor.setWatchManager(this.watchManager);
                    actor.setActualParams(this.actualParams);
                    actor.setTunnelParams(this.tunnelParams);
                    this.watchManager.addWatch(new Trigger(CHILD_NODE_SELECTION, actor, context), true);
                    return null;
                }
            }
            boolean applyTemplatesToAttributes = false;
            boolean applyTemplatesToChildren = false;
            for (int i : action) {
                if (i == 6) {
                    applyTemplatesToAttributes = true;
                    continue;
                }
                if (i != 7) continue;
                applyTemplatesToChildren = true;
            }
            if (applyTemplatesToAttributes && node.getNodeKind() == 1) {
                AxisIterator atts = node.iterateAxis((byte)2);
                XPathContextMajor c2 = this.localContext.newContext();
                c2.trackFocus(atts);
                StreamingSequenceWriter sw = new StreamingSequenceWriter(this.getPipelineConfiguration(), this.getResult());
                c2.setReceiver(sw);
                this.mode.getActor().applyTemplates(this.actualParams, this.tunnelParams, c2, locationId);
            }
            if (applyTemplatesToChildren) {
                NoOpenOrCloseFeed out = new NoOpenOrCloseFeed(this.getResult(), this.localContext);
                ApplyTemplatesAction actor = new ApplyTemplatesAction(null, out, this.getContext());
                actor.setMode(this.mode);
                actor.setWatchManager(this.watchManager);
                actor.setActualParams(this.actualParams);
                actor.setTunnelParams(this.tunnelParams);
                Trigger watch = new Trigger(CHILD_NODE_SELECTION, actor, this.localContext);
                this.watchManager.addWatch(watch, true);
            }
        } else {
            TemplateRuleEE template = (TemplateRuleEE)rule.getAction();
            template.initialize();
            Expression body = template.getBody();
            if (Streamability.getSweep(body) != Sweep.CONSUMING) {
                this.localContext.openStackFrame(template.getStackFrameMap());
                this.localContext.setLocalParameters(this.actualParams);
                this.localContext.setTunnelParameters(this.tunnelParams);
                this.localContext.setCurrentTemplateRule(rule);
                this.localContext.setCurrentMode(this.mode);
                this.localContext.setCurrentComponent(this.mode);
                this.localContext.setCurrentMergeGroupIterator(null);
                this.localContext.setReceiver(new StreamingSequenceWriter(this.getPipelineConfiguration(), this.getResult()));
                body.process(this.localContext);
            } else {
                inversion = template.getInversion();
                this.localContext.openStackFrame(inversion.getStackFrame());
                this.localContext.setLocalParameters(this.actualParams);
                this.localContext.setTunnelParameters(this.tunnelParams);
                this.localContext.setCurrentTemplateRule(rule);
                this.localContext.setCurrentMode(this.mode);
                this.localContext.setCurrentComponent(this.mode);
                this.localContext.setCurrentMergeGroupIterator(null);
            }
        }
        if (inversion != null) {
            Watch watch = inversion.getWatch(this.watchManager, new NoOpenOrCloseFeed(this.getResult(), this.getContext()), this.localContext);
            watch.setAnchorNode(node);
            this.watchManager.addWatch(watch, true);
        }
        return null;
    }

    protected Rule getRule(FleetingNode node) throws XPathException {
        return this.mode.getActor().getRule(node, this.localContext);
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.hasFailed()) {
            if (this.tracing) {
                TraceListener listener = this.getContext().getController().getTraceListener();
                listener.startCurrentItem(item);
            }
            ManualIterator iter = (ManualIterator)this.localContext.getCurrentIterator();
            iter.setContextItem(item);
            iter.incrementPosition();
            Rule rule = this.mode.getActor().getRule(item, this.localContext);
            this.localContext.setCurrentTemplateRule(rule);
            this.localContext.setCurrentComponent(this.mode);
            this.localContext.setCurrentMode(this.mode);
            if (rule == null) {
                BuiltInRuleSet rules = this.mode.getActor().getBuiltInRuleSet();
                XPathContextMinor c2 = this.localContext.newMinorContext();
                c2.setReceiver(new StreamingSequenceWriter(this.getPipelineConfiguration(), this.getResult()));
                try {
                    rules.process(item, this.actualParams, this.tunnelParams, c2, ExplicitLocation.UNKNOWN_LOCATION);
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                    return;
                }
            }
            TemplateRule template = (TemplateRule)rule.getAction();
            template.initialize();
            this.localContext.openStackFrame(template.getStackFrameMap());
            this.localContext.setReceiver(new StreamingSequenceWriter(this.getPipelineConfiguration(), this.getResult()));
            try {
                template.apply(this.localContext);
            }
            catch (XPathException e) {
                this.dynamicError(e);
                return;
            }
            if (this.tracing) {
                TraceListener listener = this.getContext().getController().getTraceListener();
                listener.endCurrentItem(item);
            }
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.tracing) {
            TraceListener listener = this.getContext().getController().getTraceListener();
            listener.endCurrentItem(this.getContext().getContextItem());
        }
    }

    @Override
    public void close() throws XPathException {
        super.close();
    }
}

