/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.ranker;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lemming.lemma.LemmaCandidateGenerator;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import marmot.util.Converter;
import marmot.util.FeatUtil;
import marmot.util.SymbolTable;

public class RankerInstance {
    public static final int[] EMPTY_ARRAY = new int[0];
    private LemmaInstance instance_;
    private LemmaCandidateSet set_;
    private short[] form_chars_;
    private int pos_index_;
    private int[] morph_indexes_;

    public RankerInstance(LemmaInstance instance, LemmaCandidateSet set) {
        this.instance_ = instance;
        this.set_ = set;
        this.form_chars_ = null;
        this.pos_index_ = -2;
        this.morph_indexes_ = null;
    }

    public LemmaInstance getInstance() {
        return this.instance_;
    }

    public LemmaCandidateSet getCandidateSet() {
        return this.set_;
    }

    public short[] getFormChars(SymbolTable<Character> char_table_, boolean insert) {
        if (this.form_chars_ == null) {
            this.form_chars_ = FeatUtil.getCharIndexes(this.instance_.getForm(), char_table_, insert);
        }
        return this.form_chars_;
    }

    public int getPosIndex(SymbolTable<String> pos_table, boolean insert) {
        if (pos_table == null || this.instance_.getPosTag() == null) {
            return -1;
        }
        if (this.pos_index_ == -2) {
            this.pos_index_ = pos_table.toIndex(this.instance_.getPosTag(), -1, insert);
        }
        return this.pos_index_;
    }

    public int[] getMorphIndexes(SymbolTable<String> morph_table, boolean insert) {
        if (morph_table == null) {
            return EMPTY_ARRAY;
        }
        if (this.morph_indexes_ == null) {
            LinkedList<Integer> list = new LinkedList<Integer>();
            this.setMorphFeatures(morph_table, this.instance_.getMorphTag(), insert, list);
            this.morph_indexes_ = list.isEmpty() ? EMPTY_ARRAY : Converter.toIntArray(list);
        }
        return this.morph_indexes_;
    }

    private void setMorphFeatures(SymbolTable<String> morph_table, String morphtag, boolean insert, List<Integer> list) {
        if (morphtag == null || morph_table == null || morphtag.equals(Character.valueOf('_'))) {
            return;
        }
        for (String feat : morphtag.split("\\|")) {
            int index = morph_table.toIndex(feat, -1, insert);
            if (index < 0 || list == null) continue;
            list.add(index);
        }
    }

    public static List<RankerInstance> getInstances(List<LemmaInstance> instances, List<LemmaCandidateGenerator> generators) {
        LinkedList<RankerInstance> rinstances = new LinkedList<RankerInstance>();
        for (LemmaInstance instance : instances) {
            rinstances.add(RankerInstance.getInstance(instance, generators));
        }
        return rinstances;
    }

    public static RankerInstance getInstance(LemmaInstance instance, List<LemmaCandidateGenerator> generators) {
        LemmaCandidateSet set = new LemmaCandidateSet();
        for (LemmaCandidateGenerator generator : generators) {
            generator.addCandidates(instance, set);
        }
        return new RankerInstance(instance, set);
    }

    public String toString() {
        return "RankerInstance [instance=" + this.instance_ + ", set_=" + this.set_ + ", form_chars=" + Arrays.toString(this.form_chars_) + ", pos_index=" + this.pos_index_ + ", morph_indexes=" + Arrays.toString(this.morph_indexes_) + "]";
    }

    public void setCandidateSet(LemmaCandidateSet set) {
        this.set_ = set;
    }
}

