/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class AxisExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        byte axis = ((AxisExpression)expression).getAxis();
        NodeTest test = ((AxisExpression)expression).getNodeTest();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        AxisExpressionCompiler.visitLineNumber(compiler, ga, expression);
        AxisExpressionCompiler.visitAnnotation(compiler, "AxisExpressionCompiler - iterate");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
        LabelInfo end = null;
        if (((AxisExpression)expression).isContextPossiblyUndefined()) {
            LabelInfo lab = methodInfo.newLabel("lab");
            end = methodInfo.newLabel("endAxis");
            ga.dup();
            ga.ifNonNull(lab.label());
            compiler.generateDynamicError("The context item for axis step " + expression.toString() + " is absent", "XPDY0002", expression.getLocation(), false);
            methodInfo.placeLabel(lab);
        }
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ItemType contextItemType = ((AxisExpression)expression).getContextItemType();
        if (contextItemType == null || !th.isSubType(((AxisExpression)expression).getContextItemType(), AnyNodeTest.getInstance())) {
            LabelInfo OK = methodInfo.newLabel("endTryAxisExpr");
            LabelInfo L0 = methodInfo.newLabel("L0");
            LabelInfo L1 = methodInfo.newLabel("L1");
            LabelInfo L2 = methodInfo.newLabel("L2");
            ga.visitTryCatchBlock(L0, L1, L2, "java/lang/ClassCastException");
            methodInfo.placeLabel(L0);
            ga.checkClass(NodeInfo.class);
            AxisExpressionCompiler.iterate(compiler, axis, test);
            methodInfo.placeLabel(L1);
            ga.goTo(OK.label());
            methodInfo.placeLabel(L2);
            AxisExpressionCompiler.visitAnnotation(compiler, "Catch");
            compiler.generateDynamicError("The context item for axis step " + expression.toString() + " is not a node", "XPTY0004", expression.getLocation(), true);
            methodInfo.placeLabel(OK);
        } else {
            ga.checkClass(NodeInfo.class);
            AxisExpressionCompiler.iterate(compiler, axis, test);
        }
        if (end != null) {
            methodInfo.placeLabel(end);
        }
    }

    public static void iterate(CompilerService compiler, int axis, NodeTest test) {
        Generator ga = compiler.getCurrentGenerator();
        AxisExpressionCompiler.visitAnnotation(compiler, "AxisExpressionCompiler - static method: iterate");
        if (test == null || test == AnyNodeTest.getInstance()) {
            ga.push(axis);
            ga.invokeInstanceMethod(NodeInfo.class, "iterateAxis", Byte.TYPE);
        } else if (test instanceof NodeKindTest) {
            int kind = test.getPrimitiveType();
            ga.push(axis);
            switch (kind) {
                case 9: {
                    ga.getStaticField(NodeKindTest.class, "DOCUMENT", NodeKindTest.class);
                    break;
                }
                case 1: {
                    ga.getStaticField(NodeKindTest.class, "ELEMENT", NodeKindTest.class);
                    break;
                }
                case 2: {
                    ga.getStaticField(NodeKindTest.class, "ATTRIBUTE", NodeKindTest.class);
                    break;
                }
                case 3: {
                    ga.getStaticField(NodeKindTest.class, "TEXT", NodeKindTest.class);
                    break;
                }
                case 8: {
                    ga.getStaticField(NodeKindTest.class, "COMMENT", NodeKindTest.class);
                    break;
                }
                case 7: {
                    ga.getStaticField(NodeKindTest.class, "PROCESSING_INSTRUCTION", NodeKindTest.class);
                    break;
                }
                case 13: {
                    ga.getStaticField(NodeKindTest.class, "NAMESPACE", NodeKindTest.class);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ga.invokeInstanceMethod(NodeInfo.class, "iterateAxis", Byte.TYPE, NodeTest.class);
        } else {
            ga.push(axis);
            AxisExpressionCompiler.allocateStatic(compiler, test);
            ga.showMessage(compiler, "calling iterateAxis");
            ga.invokeInstanceMethod(NodeInfo.class, "iterateAxis", Byte.TYPE, NodeTest.class);
            ga.showMessage(compiler, "returning axis iterator");
        }
    }
}

