/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.TypeHierarchy;

public class LocalParamCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        String name;
        LocalParam param = (LocalParam)expression;
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LocalParamCompiler.visitLineNumber(compiler, ga, expression);
        LocalParamCompiler.visitAnnotation(compiler, "LocalParam-push");
        LabelInfo paramDone = methodInfo.newLabel("paramDone");
        compiler.generateGetContext();
        LocalParamCompiler.allocateStatic(compiler, param.getVariableQName());
        ga.push(param.getSlotNumber());
        ga.push(param.isTunnelParam());
        ga.invokeInstanceMethod(XPathContext.class, "useLocalParameter", StructuredQName.class, Integer.TYPE, Boolean.TYPE);
        if (param.getConversion() != null) {
            LabelInfo notSupplied = methodInfo.newLabel("notSupplied");
            ga.dup();
            ga.push(1);
            ga.ifCmp(Type.INT_TYPE, 154, notSupplied.label());
            ga.pop();
            compiler.generateGetContext();
            ga.push(param.getSlotNumber());
            compiler.compileToSequence(param.getConversion());
            ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
            ga.goTo(paramDone);
            methodInfo.placeLabel(notSupplied);
        }
        ga.push(0);
        ga.ifCmp(Type.INT_TYPE, 154, paramDone.label());
        if (param.isImplicitlyRequiredParam()) {
            name = "$" + param.getVariableQName().getDisplayName();
            String message = "A value must be supplied for parameter " + name + " because the default value is not a valid instance of the required type";
            compiler.generateDynamicError(message, "XTDE0700", param.getLocation(), false);
        } else if (param.isRequiredParam()) {
            name = "$" + param.getVariableQName().getDisplayName();
            String message = "No value supplied for required parameter " + name;
            compiler.generateDynamicError(message, "XTDE0700", param.getLocation(), false);
        } else {
            compiler.generateGetContext();
            ga.push(param.getSlotNumber());
            compiler.generateGetContext();
            ga.dup();
            ga.invokeInstanceMethod(XPathContext.class, "getTemporaryOutputState", new Class[0]);
            int savedOutputStateVar = methodInfo.allocateLocal(Integer.TYPE);
            ga.storeLocal(savedOutputStateVar);
            ga.push(208);
            ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
            compiler.compileToSequence(param.getSelectExpression());
            compiler.generateGetContext();
            ga.loadLocal(savedOutputStateVar);
            ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
            ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        }
        methodInfo.placeLabel(paramDone);
    }
}

