/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.function.IntPredicate;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class CodepointsToStringStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new ItemFeed(this.getExpression(), out, context){
            FastStringBuffer buffer;
            IntPredicate checker;
            {
                this.buffer = new FastStringBuffer(64);
                this.checker = CodepointsToStringStreamer.this.getConfiguration().getValidCharacterChecker();
            }

            @Override
            public void processItem(Item<?> item) throws XPathException {
                if (!this.hasFailed()) {
                    long next = ((IntegerValue)item).longValue();
                    if (next < 0L || next > Integer.MAX_VALUE || !this.checker.test((int)next)) {
                        this.dynamicError(new XPathException("Invalid XML character [x " + Integer.toHexString((int)next) + ']', "FOCH0001"));
                        return;
                    }
                    this.buffer.appendWideChar((int)((IntegerValue)item).longValue());
                }
            }

            @Override
            public void close() throws XPathException {
                if (!this.hasFailed()) {
                    this.getResult().processItem(new StringValue(this.buffer.toString()));
                    super.close();
                }
                this.buffer.setLength(0);
            }
        };
    }
}

