/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleSpans
extends Spans {
    protected final Logger log = LoggerFactory.getLogger(SimpleSpans.class);
    private SimpleSpanQuery query;
    protected boolean isStartEnumeration = true;
    protected boolean collectPayloads = true;
    protected boolean hasMoreSpans;
    protected Spans firstSpans;
    protected Spans secondSpans;
    protected int matchDocNumber = -1;
    protected int matchStartPosition = -1;
    protected int matchEndPosition = -1;
    protected Collection<byte[]> matchPayload = new ArrayList<byte[]>();
    protected short spanId;
    protected boolean hasSpanId = false;
    protected byte payloadTypeIdentifier;

    public SimpleSpans() {
    }

    public SimpleSpans(SimpleSpanQuery simpleSpanQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        this();
        this.query = simpleSpanQuery;
        this.collectPayloads = this.query.isCollectPayloads();
        SpanQuery sq = simpleSpanQuery.getFirstClause();
        if (sq != null) {
            this.firstSpans = sq.getSpans(context, acceptDocs, termContexts);
        }
        if ((sq = simpleSpanQuery.getSecondClause()) != null) {
            this.secondSpans = sq.getSpans(context, acceptDocs, termContexts);
        }
    }

    protected boolean ensureSameDoc(Spans x, Spans y) throws IOException {
        while (this.hasMoreSpans && x.doc() != y.doc()) {
            if (x.doc() < y.doc()) {
                if (x.skipTo(y.doc())) continue;
                this.hasMoreSpans = false;
                return false;
            }
            if (y.skipTo(x.doc())) continue;
            this.hasMoreSpans = false;
            return false;
        }
        return true;
    }

    protected boolean findSameDoc(Spans x, Spans y, Spans e) throws IOException {
        while (this.hasMoreSpans) {
            if (this.ensureSameDoc(x, y) && e.doc() == x.doc()) {
                return true;
            }
            if (this.ensureSameDoc(e, y)) continue;
            return false;
        }
        return false;
    }

    @Override
    public int doc() {
        return this.matchDocNumber;
    }

    @Override
    public int start() {
        return this.matchStartPosition;
    }

    @Override
    public int end() {
        return this.matchEndPosition;
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return this.matchPayload;
    }

    @Override
    public boolean isPayloadAvailable() throws IOException {
        return !this.matchPayload.isEmpty();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.query.toString() + ")@" + (String)(this.isStartEnumeration ? "START" : (this.hasMoreSpans ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    public short getSpanId() {
        return this.spanId;
    }

    public void setSpanId(short spanId) {
        this.spanId = spanId;
    }

    public byte getPayloadTypeIdentifier() {
        return this.payloadTypeIdentifier;
    }

    public void setPayloadTypeIdentifier(byte payloadTypeIdentifier) {
        this.payloadTypeIdentifier = payloadTypeIdentifier;
    }
}

