/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class AtomizerCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Atomizer atomizer = (Atomizer)expression;
        Expression arg = ((Atomizer)expression).getBaseExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        AtomizerCompiler.visitAnnotation(compiler, "AtomizerCompiler-Item");
        AtomizerCompiler.visitLineNumber(compiler, ga, expression);
        compiler.compileToItem(arg);
        boolean allowEmpty = Cardinality.allowsZero(atomizer.getCardinality());
        LabelInfo end = methodInfo.newLabel("endAtomizer");
        if (allowEmpty) {
            ga.dup();
            ga.ifNull(end.label());
        }
        ga.invokeInstanceMethod(Item.class, "atomize", new Class[0]);
        ga.invokeInstanceMethod(AtomicSequence.class, "head", new Class[0]);
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        if ((requiredClass == String.class || requiredClass == CharSequence.class) && ((Atomizer)expression).isUntyped()) {
            Atomizer atomizer = (Atomizer)expression;
            Expression arg = ((Atomizer)expression).getBaseExpression();
            Generator ga = compiler.getCurrentGenerator();
            GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
            AtomizerCompiler.visitAnnotation(compiler, "AtomizerCompiler-String");
            AtomizerCompiler.visitLineNumber(compiler, ga, expression);
            boolean allowEmpty = Cardinality.allowsZero(atomizer.getCardinality());
            compiler.compileToItem(arg);
            LabelInfo exit = null;
            if (allowEmpty) {
                LabelInfo notNull = methodInfo.newLabel("ACstrNotNull");
                ga.dup();
                ga.ifNonNull(notNull.label());
                exit = methodInfo.newLabel("itemToStringExit");
                AtomizerCompiler.handleEmptyStringResult(onEmpty, ga, methodInfo, exit);
                methodInfo.placeLabel(notNull);
            }
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            if (requiredClass == String.class) {
                ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
            }
            if (exit != null) {
                methodInfo.placeLabel(exit);
            }
        } else {
            super.compileToPrimitive(compiler, expression, requiredClass, onEmpty);
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression arg = ((Atomizer)expression).getBaseExpression();
        Generator ga = compiler.getCurrentGenerator();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        AtomizerCompiler.visitAnnotation(compiler, "AtomizerCompiler-Itr");
        boolean untyped = ((Atomizer)expression).isUntyped();
        compiler.compileToIterator(arg);
        ga.push(untyped && arg.getItemType() instanceof NodeTest);
        ga.invokeStaticMethod(Atomizer.class, "getAtomizingIterator", SequenceIterator.class, Boolean.TYPE);
    }
}

