/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.ComponentWithValueConstraint;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.validate.SchemaAttributeTest;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public final class AttributeDecl
extends SchemaStructure
implements ComponentWithValueConstraint,
UserSchemaComponent,
SerializableSchemaComponent,
SchemaDeclaration {
    private UserComplexType containingComplexType = null;
    private AttributeGroupDecl containingAttributeGroup = null;
    private ValueConstraint valueConstraint;
    private boolean global;
    private StructuredQName attributeName;
    private int fingerprint;
    private TypeReference simpleTypeRef = null;
    private NamespaceResolver namespaceResolver;
    private boolean inheritable;

    public AttributeDecl(EnterpriseConfiguration config, boolean global) {
        this.global = global;
        this.setConfiguration(config);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setContainingComplexType(UserComplexType type) {
        this.containingComplexType = type;
    }

    public UserComplexType getContainingComplexType() {
        return this.containingComplexType;
    }

    public void setContainingAttributeGroup(AttributeGroupDecl type) {
        this.containingAttributeGroup = type;
    }

    public AttributeGroupDecl getContainingAttributeGroup() {
        return this.containingAttributeGroup;
    }

    public String getName() {
        return this.attributeName.getLocalPart();
    }

    public String getTargetNamespace() {
        return this.attributeName.getURI();
    }

    public String getDisplayName() {
        return this.attributeName.getDisplayName();
    }

    public void setAttributeName(StructuredQName attributeName, int fingerprint) {
        this.attributeName = attributeName;
        this.fingerprint = fingerprint;
    }

    public void setAttributeName(StructuredQName attributeName) {
        this.attributeName = attributeName;
        this.fingerprint = this.getConfiguration().getNamePool().allocateFingerprint(attributeName.getURI(), attributeName.getLocalPart());
    }

    @Override
    public StructuredQName getComponentName() {
        return this.attributeName;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setTypeReference(TypeReference type) {
        this.simpleTypeRef = type;
    }

    @Override
    public int getFingerprint() {
        return this.fingerprint;
    }

    public SimpleType getSimpleType() throws MissingComponentException {
        return (SimpleType)this.simpleTypeRef.getTarget();
    }

    @Override
    public SimpleType getType() throws MissingComponentException {
        return this.getSimpleType();
    }

    @Override
    public ValueConstraint getValueConstraint() {
        return this.valueConstraint;
    }

    public void setSimpleType(SimpleType simpleType) {
        if (this.simpleTypeRef != null) {
            this.simpleTypeRef.setTarget(simpleType);
        } else {
            this.simpleTypeRef = new TypeReference(simpleType.getFingerprint(), this.getConfiguration(), null);
            this.simpleTypeRef.setTarget(simpleType);
        }
    }

    @Override
    public void setValueConstraint(ValueConstraint vc) {
        this.valueConstraint = vc;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    @Override
    public NodeTest makeSchemaNodeTest() throws MissingComponentException {
        return new SchemaAttributeTest(this);
    }

    public void setInheritable(boolean inherit) {
        this.inheritable = inherit;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    @Override
    public boolean hasTypeAlternatives() {
        return false;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.UNVALIDATED) {
            boolean b;
            this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATING);
            SchemaType decl = (SchemaType)PreparedSchema.validateReference(this.simpleTypeRef, compiler, false);
            if (decl instanceof UserSchemaComponent && !(b = ((UserSchemaComponent)((Object)decl)).fixup(compiler))) {
                decl = null;
            }
            if (decl == null) {
                this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
                return false;
            }
        }
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        SimpleType stype;
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.INVALID) {
            this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        boolean result = true;
        SchemaType type = (SchemaType)PreparedSchema.validateReference(this.simpleTypeRef, compiler, false);
        if (type == null) {
            return true;
        }
        if (type.isComplexType()) {
            String err = "The complex type " + type.getDescription() + " cannot be used as the type of an attribute";
            compiler.error(err, this);
            return false;
        }
        SimpleType simpleType = (SimpleType)type;
        if (simpleType instanceof SimpleTypeDefinition) {
            simpleType = ((SimpleTypeDefinition)simpleType).getSimpleType();
            this.simpleTypeRef.setTarget(simpleType);
        }
        if ((stype = simpleType) == null) {
            String err = "The type of attribute " + Err.wrap(this.getDisplayName(), 2) + " has not been specified";
            compiler.error(err, this);
            result = false;
            return false;
        }
        if (stype instanceof UserSimpleType) {
            result = ((UserSimpleType)stype).validate(compiler);
        }
        if (this.getFingerprint() == 388 && stype.getFingerprint() != 560) {
            compiler.error("If the xml:id attribute is used, it must be of type xs:ID", this);
            return false;
        }
        if (result && compiler.getLanguageVersion() == 10 && this.getValueConstraint() != null && stype.getBuiltInBaseType().getFingerprint() == 560) {
            compiler.error("An attribute of type xs:ID must have no fixed or default value", this);
            return false;
        }
        if (this.valueConstraint != null) {
            result = this.valueConstraint.makeTypedValue(compiler, stype, this.getNamespaceResolver(), this);
        }
        return result;
    }

    public boolean isSameDeclaration(AttributeDecl other) {
        return this == other || this.getFingerprint() == other.getFingerprint() && this.hasSameLocation(other) || this.getTargetNamespace().equals("http://www.w3.org/XML/1998/namespace");
    }

    @Override
    public boolean isNillable() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("attribute");
        serializer.emitAttribute("id", id);
        if (this.getName() != null) {
            serializer.emitAttribute("name", this.getName());
            if (this.getTargetNamespace() != null && !this.getTargetNamespace().isEmpty()) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
            }
        }
        SimpleType type = this.getType();
        serializer.emitAttribute("type", serializer.getTypeLink(type));
        serializer.emitAttribute("global", this.isGlobal() ? "true" : "false");
        serializer.emitAttribute("inheritable", this.isInheritable() ? "true" : "false");
        if (!this.isGlobal() && this.getContainingComplexType() != null) {
            serializer.emitAttribute("containingComplexType", serializer.getId(this.getContainingComplexType(), false));
        }
        if (this.getDefaultValueLexicalForm() != null) {
            serializer.emitAttribute("default", this.getDefaultValueLexicalForm());
        }
        if (this.getValueConstraint() != null) {
            this.getValueConstraint().serialize(serializer);
        }
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        Callable callable = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue("Attribute Declaration");
                }
                case "implementation": {
                    return new ObjectValue<AttributeDecl>(this);
                }
                case "name": {
                    return new StringValue(this.getName(), BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    return new AnyURIValue(this.getTargetNamespace());
                }
                case "type definition": {
                    return this.getType().getComponentAsFunction();
                }
                case "scope": {
                    Callable scopeFunction = (context1, arguments1) -> {
                        String key1;
                        switch (key1 = arguments1[0].head().getStringValue()) {
                            case "class": {
                                return new StringValue("Scope");
                            }
                            case "variety": {
                                return new StringValue(this.isGlobal() ? "global" : "local");
                            }
                            case "parent": {
                                if (this.isGlobal()) {
                                    return EmptySequence.getInstance();
                                }
                                if (this.getContainingComplexType() != null) {
                                    return this.getContainingComplexType().getComponentAsFunction();
                                }
                                if (this.getContainingAttributeGroup() != null) {
                                    return this.getContainingAttributeGroup().getComponentAsFunction();
                                }
                                return EmptySequence.getInstance();
                            }
                        }
                        return EmptySequence.getInstance();
                    };
                    return new CallableFunction(1, scopeFunction, COMPONENT_FUNCTION_TYPE);
                }
                case "value constraint": {
                    return this.getValueConstraintAsFunction(this);
                }
                case "inheritable": {
                    return BooleanValue.get(this.isInheritable());
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, callable, COMPONENT_FUNCTION_TYPE);
    }
}

