/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.ClassSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanClassQuery
extends SimpleSpanQuery {
    protected byte number = 1;

    public SpanClassQuery(SpanQuery operand) {
        super(operand, false);
    }

    public SpanClassQuery(SpanQuery operand, byte number) {
        super(operand, false);
        this.number = number;
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer("{");
        short classNr = this.number;
        buffer.append(classNr & 0xFF).append(": ");
        buffer.append(this.firstClause.toString()).append('}');
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new ClassSpans(this.firstClause, context, acceptDocs, termContexts, this.number);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery query = (SpanQuery)this.firstClause.rewrite(reader);
        if (query != this.firstClause) {
            if (query.getField() == null) {
                return query;
            }
            SpanClassQuery clone = this.clone();
            clone.firstClause = query;
            return clone;
        }
        return this;
    }

    @Override
    public SpanClassQuery clone() {
        SpanClassQuery spanClassQuery = new SpanClassQuery((SpanQuery)this.firstClause.clone(), this.number);
        spanClassQuery.setBoost(this.getBoost());
        return spanClassQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanClassQuery)) {
            return false;
        }
        SpanClassQuery spanClassQuery = (SpanClassQuery)o;
        if (!this.firstClause.equals(spanClassQuery.firstClause)) {
            return false;
        }
        if (this.number != spanClassQuery.number) {
            return false;
        }
        return this.getBoost() == spanClassQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = this.firstClause.hashCode();
        result += this.number;
        result ^= result << 15 | result >>> 18;
        return result += Float.floatToRawIntBits(this.getBoost());
    }

    public byte getNumber() {
        return this.number;
    }

    public void setNumber(byte number) {
        this.number = number;
    }
}

