/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.config.EnterpriseTransformerFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.jaxp.StreamingTransformerImpl;
import net.sf.saxon.jaxp.TemplatesImpl;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;

public class StreamingTransformerFactory
extends EnterpriseTransformerFactory {
    public StreamingTransformerFactory() {
    }

    public StreamingTransformerFactory(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    @Override
    public void setConfiguration(Configuration config) {
        config.checkLicensedFeature(2, "XSLT streaming", -1);
        super.setConfiguration(config);
    }

    @Override
    public synchronized Templates newTemplates(Source source) throws TransformerConfigurationException {
        Templates t = super.newTemplates(source);
        ((TemplatesImpl)t).setForceStreaming(true);
        return t;
    }

    @Override
    public synchronized Templates newTemplates(Source source, CompilerInfo info) throws TransformerConfigurationException {
        Templates t = super.newTemplates(source, info);
        ((TemplatesImpl)t).setForceStreaming(true);
        return t;
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        StreamingTransformerImpl transformer = (StreamingTransformerImpl)templates.newTransformer();
        try {
            return transformer.newTransformerHandler();
        }
        catch (XPathException e) {
            throw new TransformerConfigurationException(e);
        }
    }
}

