/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class BlockAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = BlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        this.consumingArg = BlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return new BlockFeed((Block)this.getExpression(), this.consumingArg, out, context);
    }

    private static class BlockFeed
    extends ItemFeed {
        int consumingArg;

        public BlockFeed(Block exp, int arg, Feed result, XPathContext context) {
            super(exp, result, context);
            this.consumingArg = arg;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            Block block = (Block)this.getExpression();
            Feed result = this.getResult();
            for (int i = 0; i < this.consumingArg; ++i) {
                Expression child = block.getOperanda()[i].getChildExpression();
                SequenceIterator<?> iter = child.iterate(this.getContext());
                BlockFeed.processItems(iter, result);
            }
        }

        @Override
        public void close() throws XPathException {
            Block block = (Block)this.getExpression();
            Feed result = this.getResult();
            for (int i = this.consumingArg + 1; i < block.getOperanda().length; ++i) {
                Expression child = block.getOperanda()[i].getChildExpression();
                SequenceIterator<?> iter = child.iterate(this.getContext());
                BlockFeed.processItems(iter, result);
            }
            result.close();
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            this.getResult().processItem(item);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return this.getResult().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResult().endSelectedParentNode(locationId);
        }
    }
}

