/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

public class MapEntryStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 1 ? this : this.getDefaultFeedMaker(arg);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new MapEntryFeed(this.getExpression(), out, context);
    }

    private class MapEntryFeed
    extends ItemFeed {
        List<Item> value;

        public MapEntryFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.value = new ArrayList<Item>();
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            this.value.add(item);
        }

        @Override
        public void close() throws XPathException {
            AtomicValue key = (AtomicValue)((SystemFunctionCall)this.getExpression()).getArg(0).evaluateItem(this.getContext());
            GroundedValue<Item> seq = SequenceExtent.makeSequenceExtent(this.value);
            HashTrieMap map = HashTrieMap.singleton(key, seq);
            this.getResult().processItem(map);
            this.getResult().close();
        }
    }
}

