/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.functions.extfn.ObjectMap;
import com.saxonica.functions.hof.CurriedFunction;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ObjectLookupExpression
extends LookupExpression {
    private Function reflexiveFunction = null;

    public ObjectLookupExpression(Expression start, Expression step) {
        super(start, step);
    }

    @Override
    public final ItemType getItemType() {
        ItemType objectType = this.getLhsExpression().getItemType();
        if (objectType instanceof JavaExternalObjectType && this.getRhsExpression() instanceof StringLiteral) {
            String fieldName = ((StringLiteral)this.getRhsExpression()).getStringValue();
            Map<String, Function> methodMap = this.getConfiguration().makeMethodMap(((JavaExternalObjectType)objectType).getJavaClass(), fieldName);
            Function f = methodMap.get(fieldName);
            if (f != null) {
                return f.getFunctionItemType();
            }
            return ErrorType.getInstance();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Configuration config = visitor.getConfiguration();
        this.getLhs().typeCheck(visitor, contextInfo);
        this.isSingleContainer = this.getLhsExpression().getCardinality() == 16384;
        this.getRhs().typeCheck(visitor, contextInfo);
        RoleDiagnostic role = new RoleDiagnostic(1, "?", 1);
        TypeChecker tc = config.getTypeChecker(false);
        SequenceType req = BuiltInAtomicType.STRING.oneOrMore();
        this.setRhsExpression(tc.staticTypeCheck(this.getRhsExpression(), req, role, visitor));
        boolean bl = this.isSingleEntry = this.getRhsExpression().getCardinality() == 16384;
        if (this.getRhsExpression() instanceof StringLiteral) {
            ItemType containerType = this.getLhsExpression().getItemType();
            JavaExternalObjectType target = (JavaExternalObjectType)containerType;
            Class<?> theClass = target.getJavaClass();
            String methodName = ((StringLiteral)this.getRhsExpression()).getStringValue();
            if (methodName.equals("this")) {
                return this;
            }
            Map<String, Function> methodMap = ObjectMap.makeMethodMap(config, theClass, methodName);
            Function f = methodMap.get(methodName);
            if (f == null) {
                XPathException err = new XPathException("No unique method " + methodName + " found in class " + theClass, "XPTY0004");
                err.setIsTypeError(true);
                err.setLocation(this.getLocation());
                throw err;
            }
            this.reflexiveFunction = f;
        }
        return this;
    }

    @Override
    public LookupExpression copy(RebindingMap rebindings) {
        ObjectLookupExpression exp = new ObjectLookupExpression(this.getLhsExpression().copy(rebindings), this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        exp.isArrayLookup = false;
        exp.isMapLookup = false;
        exp.isSingleEntry = this.isSingleEntry;
        exp.isSingleContainer = this.isSingleContainer;
        return exp;
    }

    @Override
    public int computeCardinality() {
        if (this.isSingleContainer && this.isSingleEntry) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext context) throws XPathException {
        Configuration config = context.getConfiguration();
        SequenceIterator<?> baseIterator = this.getLhsExpression().iterate(context);
        if (this.reflexiveFunction != null) {
            return new ItemMappingIterator<Item, CurriedFunction>(baseIterator, item -> {
                Sequence[] boundArgs = new Sequence[this.reflexiveFunction.getArity()];
                boundArgs[0] = item;
                return new CurriedFunction(this.reflexiveFunction, boundArgs);
            });
        }
        GroundedValue<?> rhs = this.getRhsExpression().iterate(context).materialize();
        String key = rhs.getStringValue();
        return new ItemMappingIterator<Item, Item>(baseIterator, item -> (Item)config.externalObjectAsMap((ObjectValue)item, key).get((StringValue)rhs));
    }
}

