/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascNamedEntitySampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

public class MascNamedEntitySampleStreamFactory<P>
extends AbstractSampleStreamFactory<NameSample, P> {
    public static final String MASC_FORMAT = "masc";

    protected MascNamedEntitySampleStreamFactory(Class<P> params) {
        super(params);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, MASC_FORMAT, new MascNamedEntitySampleStreamFactory<Parameters>(Parameters.class));
    }

    @Override
    public ObjectStream<NameSample> create(String[] args2) {
        Parameters params = ArgumentParser.parse(args2, Parameters.class);
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains(params.getFileFilter());
            return new MascNamedEntitySampleStream(new MascDocumentStream(params.getData(), params.getRecurrentSearch(), fileFilter));
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="recurrentSearch", description="search through files recursively")
        public boolean getRecurrentSearch();

        @ArgumentParser.ParameterDescription(valueName="fileFilterString", description="only include files which contain a given string in their name")
        public String getFileFilter();
    }
}

