/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.Verifier;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.trans.LicenseException;

public class JavaVerifier
extends Verifier {
    private static final String PUBLIC_KEY = "308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A038184000281806CA067E469754A2F98D08965D35AB41252974F69FCD260152CFB58F94D8B956D6A1A91CC213A11107301DD37C85B383DDA409EC067D2A8C4BE6651020A69AFD533630172D6F96F928667D7705D46E56D364E8E967002A7D864BACB02225F52B271BA1F6522D98FF8299C6273B24BC41202C8857897E46B40FD7624A9CB0CC9E8";
    private static final byte[] ENCODED_PUBLIC_KEY = JavaVerifier.convertHexToBinary("308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A038184000281806CA067E469754A2F98D08965D35AB41252974F69FCD260152CFB58F94D8B956D6A1A91CC213A11107301DD37C85B383DDA409EC067D2A8C4BE6651020A69AFD533630172D6F96F928667D7705D46E56D364E8E967002A7D864BACB02225F52B271BA1F6522D98FF8299C6273B24BC41202C8857897E46B40FD7624A9CB0CC9E8");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadLicense(Configuration config) {
        InputStream is = null;
        try {
            ArrayList<String> attempts = new ArrayList<String>(4);
            is = this.lookInCodeLocation(attempts);
            if (is == null) {
                is = JavaVerifier.lookInInstallationDirectory(config, attempts);
            }
            if (is == null) {
                is = JavaVerifier.lookInClassPath();
            }
            if (is == null) {
                attempts.add("classpath");
                StringBuilder message = new StringBuilder("License file saxon-license.lic not found. Tried in ");
                for (int i = 0; i < attempts.size(); ++i) {
                    message.append((String)attempts.get(i));
                    if (i < attempts.size() - 2) {
                        message.append(", ");
                        continue;
                    }
                    if (i != attempts.size() - 2) continue;
                    message.append(", and ");
                }
                throw new LicenseException(message.toString(), 3);
            }
            Verifier.License lic = this.readLicenseFile(is);
            this.setPrimaryLicense(lic);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected boolean verify(String data, String signature) throws LicenseException {
        try {
            Signature sig = Signature.getInstance("DSA");
            PublicKey key = KeyFactory.getInstance("DSA").generatePublic(new X509EncodedKeySpec(ENCODED_PUBLIC_KEY));
            sig.initVerify(key);
            sig.update(data.getBytes(StandardCharsets.UTF_8));
            return sig.verify(JavaVerifier.convertHexToBinary(signature));
        }
        catch (GeneralSecurityException e) {
            throw new LicenseException("Failed to verify license signature: " + e.getMessage(), 2);
        }
    }

    private static InputStream lookInClassPath() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.getResourceAsStream("saxon-license.lic");
    }

    private static InputStream lookInInstallationDirectory(Configuration config, List<String> attempts) {
        String home = Version.platform.getInstallationDirectory(Version.softwareEdition, config);
        FileInputStream is = null;
        if (home != null) {
            String path = home.endsWith("/") || home.endsWith("\\") ? home + "bin/" + "saxon-license.lic" : home + "/bin/" + "saxon-license.lic";
            attempts.add(path);
            try {
                is = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                path = home.endsWith("/") || home.endsWith("\\") ? home + "saxon-license.lic" : home + "/" + "saxon-license.lic";
                attempts.add(path);
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return is;
    }

    private InputStream lookInCodeLocation(List<String> attempts) {
        try {
            URL sourceLoc;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            if (codeSource != null && (sourceLoc = codeSource.getLocation()) != null) {
                URL licenseLoc = new URL(sourceLoc, "saxon-license.lic");
                attempts.add(licenseLoc.toString());
                return licenseLoc.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

