/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.PatternWatch;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class MultiAccumulatorWatch
extends PatternWatch {
    private final Stack<FleetingNode> nodeStack = new Stack();
    private final Map<Accumulator, AccumulatorWatch> accumulatorMap;

    public MultiAccumulatorWatch(Map<Accumulator, AccumulatorWatch> accumulatorMap) {
        this.accumulatorMap = accumulatorMap;
        this.setSelection(new NodeTestPattern(AnyNodeTest.getInstance()));
    }

    public Map<Accumulator, AccumulatorWatch> getAccumulatorMap() {
        return this.accumulatorMap;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        for (AccumulatorWatch watch : this.accumulatorMap.values()) {
            watch.open(terminator);
            watch.setNodeStack(this.nodeStack);
        }
    }

    public void setWatchManager(WatchManager watchManager) {
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        this.nodeStack.push(node);
        for (AccumulatorWatch watch : this.accumulatorMap.values()) {
            watch.startSelectedParentNode(node, locationId);
        }
        return null;
    }

    @Override
    public void processItem(Item item) throws XPathException {
        FleetingNode node = (FleetingNode)item;
        if (node.getNodeKind() == 2) {
            return;
        }
        for (AccumulatorWatch watch : this.accumulatorMap.values()) {
            watch.processItem(node);
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        for (AccumulatorWatch watch : this.accumulatorMap.values()) {
            watch.endSelectedParentNode(locationId);
        }
        this.nodeStack.pop();
    }

    @Override
    public void close() throws XPathException {
    }
}

